/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractScpTransferEventListenerAdapter
extends AbstractLoggingBean
implements ScpTransferEventListener {
    protected AbstractScpTransferEventListenerAdapter() {
    }

    @Override
    public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("startFileEvent({})[{}] - length={}, permissions={}, file={}", new Object[]{session, op, length, perms, file});
        }
    }

    @Override
    public void endFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("endFileEvent({})[{}] - length={}, permissions={}, file={} - {}", new Object[]{session, op, length, perms, file, thrown == null ? "OK" : thrown.getClass().getSimpleName() + ": " + thrown.getMessage()});
        }
    }

    @Override
    public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("startFolderEvent({})[{}] - permissions={}, file={}", new Object[]{session, op, perms, file});
        }
    }

    @Override
    public void endFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("endFolderEvent({})[{}] - permissions={}, file={} - {}", new Object[]{session, op, perms, file, thrown == null ? "OK" : thrown.getClass().getSimpleName() + ": " + thrown.getMessage()});
        }
    }
}

