/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.system.FrameworkType;
import org.apache.karaf.system.SystemService;

@Command(scope="system", name="framework", description="OSGi Framework options.")
@Service
public class FrameworkOptions
implements Action {
    @Option(name="-debug", aliases={"--enable-debug"}, description="Enable debug for the OSGi framework", required=false, multiValued=false)
    boolean debug;
    @Option(name="-nodebug", aliases={"--disable-debug"}, description="Disable debug for the OSGi framework", required=false, multiValued=false)
    boolean nodebug;
    @Argument(name="framework", required=false, description="Name of the OSGi framework to use")
    String framework;
    @Reference
    SystemService systemService;

    public Object execute() throws Exception {
        FrameworkType frameworkType;
        if (!this.debug ^ this.nodebug && this.framework == null) {
            System.out.printf("Current OSGi framework is %s%n", this.systemService.getFramework().name());
            return null;
        }
        if (this.framework != null) {
            frameworkType = FrameworkType.valueOf(this.framework);
            this.systemService.setFramework(frameworkType);
            System.out.println("Changed OSGi framework to " + frameworkType.toString().toLowerCase() + ". Karaf needs to be restarted to make the change effective");
        }
        if (this.debug) {
            frameworkType = this.systemService.getFramework();
            System.out.printf("Enabling debug for OSGi framework (%s)%n", frameworkType.name());
            this.systemService.setFrameworkDebug(true);
        }
        if (this.nodebug) {
            frameworkType = this.systemService.getFramework();
            System.out.printf("Disabling debug for OSGi framework (%s)%n", frameworkType.name());
            this.systemService.setFrameworkDebug(false);
        }
        return null;
    }
}

