/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http.optional;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.NativeHandlers;
import groovyx.net.http.ToServer;
import groovyx.net.http.TransportingException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class Csv {
    public static final Supplier<BiConsumer<ChainedHttpConfig, ToServer>> encoderSupplier = () -> Csv::encode;
    public static final Supplier<BiFunction<ChainedHttpConfig, FromServer, Object>> parserSupplier = () -> Csv::parse;

    public static Object parse(ChainedHttpConfig config, FromServer fromServer) {
        try {
            Context ctx = (Context)config.actualContext(fromServer.getContentType(), "3DOJ0FPjyD4GwLmpMjrCYnNJK60=");
            return ctx.makeReader(fromServer.getReader()).readAll();
        }
        catch (IOException e) {
            throw new TransportingException(e);
        }
    }

    public static void encode(ChainedHttpConfig config, ToServer ts) {
        if (NativeHandlers.Encoders.handleRawUpload(config, ts)) {
            return;
        }
        ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
        Context ctx = (Context)config.actualContext(request.actualContentType(), "3DOJ0FPjyD4GwLmpMjrCYnNJK60=");
        Object body = NativeHandlers.Encoders.checkNull(request.actualBody());
        NativeHandlers.Encoders.checkTypes(body, new Class[]{Iterable.class});
        StringWriter writer = new StringWriter();
        CSVWriter csvWriter = ctx.makeWriter(new StringWriter());
        Iterable iterable = (Iterable)body;
        for (Object o : iterable) {
            csvWriter.writeNext((String[])o);
        }
        ts.toServer(NativeHandlers.Encoders.stringToStream(writer.toString(), request.actualCharset()));
    }

    public static void toCsv(HttpConfig delegate, String contentType, Character separator, Character quote) {
        delegate.context(contentType, (Object)"3DOJ0FPjyD4GwLmpMjrCYnNJK60=", (Object)new Context(separator, quote));
        delegate.getRequest().encoder(contentType, Csv::encode);
        delegate.getResponse().parser(contentType, Csv::parse);
    }

    public static void toCsv(HttpConfig delegate, char separator) {
        Csv.toCsv(delegate, "text/csv", Character.valueOf(separator), null);
    }

    public static void toCsv(HttpConfig delegate, char separator, char quote) {
        Csv.toCsv(delegate, "text/csv", Character.valueOf(separator), Character.valueOf(quote));
    }

    public static void toTsv(HttpConfig delegate, char quote) {
        Csv.toCsv(delegate, "text/tab-separated-values", Character.valueOf('\t'), Character.valueOf(quote));
    }

    public static class Context {
        public static final String ID = "3DOJ0FPjyD4GwLmpMjrCYnNJK60=";
        public static final Context DEFAULT_CSV = new Context(Character.valueOf(','));
        public static final Context DEFAULT_TSV = new Context(Character.valueOf('\t'));
        private final Character separator;
        private final Character quoteChar;

        public Context(Character separator) {
            this(separator, null);
        }

        public Context(Character separator, Character quoteChar) {
            this.separator = separator;
            this.quoteChar = quoteChar;
        }

        public char getSeparator() {
            return this.separator.charValue();
        }

        public boolean hasQuoteChar() {
            return this.quoteChar != null;
        }

        public char getQuoteChar() {
            return this.quoteChar.charValue();
        }

        private CSVReader makeReader(Reader reader) {
            if (this.hasQuoteChar()) {
                return new CSVReader(reader, this.separator.charValue(), this.quoteChar.charValue());
            }
            return new CSVReader(reader, this.separator.charValue());
        }

        private CSVWriter makeWriter(Writer writer) {
            if (this.hasQuoteChar()) {
                return new CSVWriter(writer, this.separator.charValue(), this.quoteChar.charValue());
            }
            return new CSVWriter(writer, this.separator.charValue());
        }
    }
}

