/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.parsers;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.jts.geom.Coordinate;

public class CoordinateNode
implements ToXContentObject {
    public final Coordinate coordinate;
    public final List<CoordinateNode> children;

    CoordinateNode(Coordinate coordinate) {
        this.coordinate = coordinate;
        this.children = null;
    }

    CoordinateNode(List<CoordinateNode> children) {
        this.children = children;
        this.coordinate = null;
    }

    public boolean isEmpty() {
        return this.coordinate == null && (this.children == null || this.children.isEmpty());
    }

    protected int numDimensions() {
        if (this.isEmpty()) {
            throw new ElasticsearchException("attempting to get number of dimensions on an empty coordinate node", new Object[0]);
        }
        if (this.coordinate != null) {
            return Double.isNaN(this.coordinate.z) ? 2 : 3;
        }
        return this.children.get(0).numDimensions();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.children == null) {
            builder.startArray().value(this.coordinate.x).value(this.coordinate.y).endArray();
        } else {
            builder.startArray();
            for (CoordinateNode child : this.children) {
                child.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder;
    }
}

