/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSchException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAKeyPairIdentity
implements Identity {
    private static final String ALGORITHM_TYPE = "ssh-rsa";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private KeyPair keyPair;
    private String name;

    public RSAKeyPairIdentity(String name, KeyPair keyPair) {
        this.name = name;
        this.keyPair = keyPair;
    }

    public boolean setPassphrase(byte[] passphrase) throws JSchException {
        return true;
    }

    public byte[] getPublicKeyBlob() {
        RSAPublicKey publicKey = (RSAPublicKey)this.keyPair.getPublic();
        byte[] sshRsa = ALGORITHM_TYPE.getBytes();
        byte[] eArray = publicKey.getPublicExponent().toByteArray();
        byte[] nArray = publicKey.getModulus().toByteArray();
        byte[] result = new byte[sshRsa.length + 4 + eArray.length + 4 + nArray.length + 4];
        int index = 0;
        byte[] intAsByteArray = ByteBuffer.allocate(4).putInt(sshRsa.length).array();
        System.arraycopy(intAsByteArray, 0, result, index, 4);
        System.arraycopy(sshRsa, 0, result, index += 4, sshRsa.length);
        intAsByteArray = ByteBuffer.allocate(4).putInt(eArray.length).array();
        System.arraycopy(intAsByteArray, 0, result, index += sshRsa.length, 4);
        System.arraycopy(eArray, 0, result, index += 4, eArray.length);
        intAsByteArray = ByteBuffer.allocate(4).putInt(nArray.length).array();
        System.arraycopy(intAsByteArray, 0, result, index += eArray.length, 4);
        System.arraycopy(nArray, 0, result, index += 4, nArray.length);
        return result;
    }

    public byte[] getSignature(byte[] data) {
        PrivateKey prvKey = this.keyPair.getPrivate();
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initSign(prvKey);
            sig.update(data);
            byte[] sshRsa = ALGORITHM_TYPE.getBytes();
            byte[] signature = sig.sign();
            byte[] result = new byte[sshRsa.length + 4 + signature.length + 4];
            int index = 0;
            byte[] intAsByteArray = ByteBuffer.allocate(4).putInt(sshRsa.length).array();
            System.arraycopy(intAsByteArray, 0, result, index, 4);
            System.arraycopy(sshRsa, 0, result, index += 4, sshRsa.length);
            intAsByteArray = ByteBuffer.allocate(4).putInt(signature.length).array();
            System.arraycopy(intAsByteArray, 0, result, index += sshRsa.length, 4);
            System.arraycopy(signature, 0, result, index += 4, signature.length);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Cannot sign", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            this.log.error("Cannot sign", (Throwable)e);
        }
        catch (SignatureException e) {
            this.log.error("Cannot sign", (Throwable)e);
        }
        return null;
    }

    public boolean decrypt() {
        return true;
    }

    public String getAlgName() {
        return ALGORITHM_TYPE;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEncrypted() {
        return false;
    }

    public void clear() {
    }
}

