/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.SSLWrapperFactory;

public class SSLServerSocketWrapper
extends SSLServerSocket {
    protected SSLServerSocket s;
    protected SSL ssl;
    protected SSLWrapperFactory wf;

    public SSLServerSocketWrapper(SSLServerSocket s, SSL ssl, SSLWrapperFactory wf) throws IOException {
        this.s = s;
        this.ssl = ssl;
        this.wf = wf;
    }

    public Socket accept() throws IOException {
        SSLSocket secureSocket = (SSLSocket)this.s.accept();
        this.ssl.doPreConnectSocketStuff(secureSocket);
        InetAddress addr = secureSocket.getInetAddress();
        String hostName = addr.getHostName();
        this.ssl.doPostConnectSocketStuff(secureSocket, hostName);
        return this.wf.wrap(secureSocket);
    }

    public String[] getEnabledCipherSuites() {
        return this.s.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.s.getEnabledProtocols();
    }

    public boolean getEnableSessionCreation() {
        return this.s.getEnableSessionCreation();
    }

    public boolean getNeedClientAuth() {
        return this.s.getNeedClientAuth();
    }

    public String[] getSupportedCipherSuites() {
        return this.s.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.s.getSupportedProtocols();
    }

    public boolean getUseClientMode() {
        return this.s.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.s.getWantClientAuth();
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.s.setEnabledCipherSuites(suites);
    }

    public void setEnabledProtocols(String[] protocols) {
        this.s.setEnabledProtocols(protocols);
    }

    public void setEnableSessionCreation(boolean flag) {
        this.s.setEnableSessionCreation(flag);
    }

    public void setNeedClientAuth(boolean need) {
        this.s.setNeedClientAuth(need);
    }

    public void setUseClientMode(boolean use) {
        this.s.setUseClientMode(use);
    }

    public void setWantClientAuth(boolean want) {
        this.s.setWantClientAuth(want);
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.s.bind(endpoint);
    }

    public void bind(SocketAddress ep, int bl) throws IOException {
        this.s.bind(ep, bl);
    }

    public void close() throws IOException {
        this.s.close();
    }

    public ServerSocketChannel getChannel() {
        return this.s.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.s.getInetAddress();
    }

    public int getLocalPort() {
        return this.s.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.s.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.s.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.s.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.s.getSoTimeout();
    }

    public boolean isBound() {
        return this.s.isBound();
    }

    public boolean isClosed() {
        return this.s.isClosed();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.s.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.s.setReuseAddress(on);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.s.setSoTimeout(timeout);
    }

    public String toString() {
        return this.s.toString();
    }
}

