/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.QueryVectorBuilderVariant;
import co.elastic.clients.elasticsearch._types.TextEmbedding;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class QueryVectorBuilder
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<QueryVectorBuilder> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryVectorBuilder::setupQueryVectorBuilderDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public QueryVectorBuilder(QueryVectorBuilderVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._queryVectorBuilderKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private QueryVectorBuilder(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static QueryVectorBuilder of(Function<Builder, ObjectBuilder<QueryVectorBuilder>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTextEmbedding() {
        return this._kind == Kind.TextEmbedding;
    }

    public TextEmbedding textEmbedding() {
        return (TextEmbedding)TaggedUnionUtils.get(this, Kind.TextEmbedding);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupQueryVectorBuilderDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::textEmbedding, TextEmbedding._DESERIALIZER, "text_embedding");
    }

    public static enum Kind implements JsonEnum
    {
        TextEmbedding("text_embedding");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryVectorBuilder> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<QueryVectorBuilder> textEmbedding(TextEmbedding v) {
            this._kind = Kind.TextEmbedding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<QueryVectorBuilder> textEmbedding(Function<TextEmbedding.Builder, ObjectBuilder<TextEmbedding>> fn) {
            return this.textEmbedding(fn.apply(new TextEmbedding.Builder()).build());
        }

        @Override
        public QueryVectorBuilder build() {
            this._checkSingleUse();
            return new QueryVectorBuilder(this);
        }
    }
}

