/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedAsyncProcessorAwaitManagerMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed AsyncProcessorAwaitManager")
public class ManagedAsyncProcessorAwaitManager
extends ManagedService
implements ManagedAsyncProcessorAwaitManagerMBean {
    private final AsyncProcessorAwaitManager manager;

    public ManagedAsyncProcessorAwaitManager(CamelContext context, AsyncProcessorAwaitManager manager) {
        super(context, manager);
        this.manager = manager;
    }

    public AsyncProcessorAwaitManager getAsyncProcessorAwaitManager() {
        return this.manager;
    }

    @Override
    public boolean isInterruptThreadsWhileStopping() {
        return this.manager.isInterruptThreadsWhileStopping();
    }

    @Override
    public void setInterruptThreadsWhileStopping(boolean interruptThreadsWhileStopping) {
        this.manager.setInterruptThreadsWhileStopping(interruptThreadsWhileStopping);
    }

    @Override
    public int getSize() {
        return this.manager.size();
    }

    @Override
    public TabularData browse() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listAwaitThreadsTabularType());
            Collection<AsyncProcessorAwaitManager.AwaitThread> threads = this.manager.browse();
            for (AsyncProcessorAwaitManager.AwaitThread entry : threads) {
                CompositeType ct = CamelOpenMBeanTypes.listAwaitThreadsCompositeType();
                String id = "" + entry.getBlockedThread().getId();
                String name = entry.getBlockedThread().getName();
                String exchangeId = entry.getExchange().getExchangeId();
                String routeId = entry.getRouteId();
                String nodeId = entry.getNodeId();
                String duration = "" + entry.getWaitDuration();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"id", "name", "exchangeId", "routeId", "nodeId", "duration"}, new Object[]{id, name, exchangeId, routeId, nodeId, duration});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void interrupt(String exchangeId) {
        this.manager.interrupt(exchangeId);
    }

    @Override
    public long getThreadsBlocked() {
        return this.manager.getStatistics().getThreadsBlocked();
    }

    @Override
    public long getThreadsInterrupted() {
        return this.manager.getStatistics().getThreadsInterrupted();
    }

    @Override
    public long getTotalDuration() {
        return this.manager.getStatistics().getTotalDuration();
    }

    @Override
    public long getMinDuration() {
        return this.manager.getStatistics().getMinDuration();
    }

    @Override
    public long getMaxDuration() {
        return this.manager.getStatistics().getMaxDuration();
    }

    @Override
    public long getMeanDuration() {
        return this.manager.getStatistics().getMeanDuration();
    }

    @Override
    public void resetStatistics() {
        this.manager.getStatistics().reset();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.manager.getStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.manager.getStatistics().setStatisticsEnabled(statisticsEnabled);
    }
}

