
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Using compareDocumentPosition check the document position of the EntityReference node ent4's
 *  first child and last child.  Invoke compareDocumentPositon on first child with last child as a parameter
 *  should return FOLLOWING, and should return PRECEDING vice versa.
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Node3-compareDocumentPosition</a>
*/
public final class nodecomparedocumentposition28 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodecomparedocumentposition28(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList varList;
      Element varElem;
      EntityReference entRef;
      Element entRefChild1;
      ProcessingInstruction entRefChild2;
      int entRefChild1Position;
      int entRefChild2Position;
      doc = (Document) load("hc_staff", false);
      
      if (!isExpandEntityReferences()) {
          varList = doc.getElementsByTagName("var");
      varElem = (Element) varList.item(2);
      assertNotNull("varElemNotNull", varElem);
      entRef = (EntityReference) varElem.getFirstChild();
      assertNotNull("entRefNotNull", entRef);
      } else {
          entRef = doc.createEntityReference("ent4");
      }
        
    entRefChild1 = (Element) entRef.getFirstChild();
      assertNotNull("entRefChild1NotNull", entRefChild1);
      entRefChild2 = (ProcessingInstruction) entRef.getLastChild();
      assertNotNull("entRefChild2NotNull", entRefChild2);
      entRefChild1Position = (int) entRefChild1.compareDocumentPosition(entRefChild2);
      assertEquals("nodecomparedocumentpositionFollowing28", 4, entRefChild1Position);
      entRefChild2Position = (int) entRefChild2.compareDocumentPosition(entRefChild1);
      assertEquals("nodecomparedocumentpositionPRECEDING28", 2, entRefChild2Position);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodecomparedocumentposition28";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodecomparedocumentposition28.class, args);
   }
}

