/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class DelegatingAsyncDistributedCollection<E>
extends DelegatingAsyncPrimitive
implements AsyncDistributedCollection<E> {
    private final AsyncDistributedCollection<E> delegateCollection;

    public DelegatingAsyncDistributedCollection(AsyncDistributedCollection<E> delegateCollection) {
        super(delegateCollection);
        this.delegateCollection = delegateCollection;
    }

    @Override
    public CompletableFuture<Boolean> add(E element) {
        return this.delegateCollection.add(element);
    }

    @Override
    public CompletableFuture<Boolean> remove(E element) {
        return this.delegateCollection.remove(element);
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.delegateCollection.size();
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.delegateCollection.isEmpty();
    }

    @Override
    public CompletableFuture<Boolean> contains(E element) {
        return this.delegateCollection.contains(element);
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        return this.delegateCollection.addAll(c);
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
        return this.delegateCollection.containsAll(c);
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        return this.delegateCollection.retainAll(c);
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        return this.delegateCollection.removeAll(c);
    }

    @Override
    public CompletableFuture<Void> addListener(CollectionEventListener<E> listener, Executor executor) {
        return this.delegateCollection.addListener(listener, executor);
    }

    @Override
    public CompletableFuture<Void> removeListener(CollectionEventListener<E> listener) {
        return this.delegateCollection.removeListener(listener);
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.delegateCollection.clear();
    }

    @Override
    public AsyncIterator<E> iterator() {
        return this.delegateCollection.iterator();
    }

    @Override
    public DistributedCollection<E> sync(Duration operationTimeout) {
        return new BlockingDistributedCollection(this, operationTimeout.toMillis());
    }
}

