/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.counter.impl;

import com.google.common.base.Preconditions;
import io.atomix.core.counter.AsyncAtomicCounter;
import io.atomix.primitive.resource.PrimitiveResource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicCounterResource
implements PrimitiveResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicCounterResource.class);
    private final AsyncAtomicCounter counter;

    public AtomicCounterResource(AsyncAtomicCounter counter) {
        this.counter = (AsyncAtomicCounter)Preconditions.checkNotNull((Object)counter);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public void get(@Suspended AsyncResponse response) {
        this.counter.get().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"text/plain"})
    public void set(Long value, @Suspended AsyncResponse response) {
        this.counter.set(value).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/inc")
    @Produces(value={"application/json"})
    public void incrementAndGet(@Suspended AsyncResponse response) {
        this.counter.incrementAndGet().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

