/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.counter.impl;

import io.atomix.core.counter.AtomicCounterType;
import io.atomix.core.counter.impl.AtomicCounterService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultAtomicCounterService
extends AbstractPrimitiveService
implements AtomicCounterService {
    private final AtomicLong counter = new AtomicLong();

    public DefaultAtomicCounterService() {
        super((PrimitiveType)AtomicCounterType.instance());
    }

    public void backup(BackupOutput writer) {
        writer.writeLong(this.counter.get());
    }

    public void restore(BackupInput reader) {
        this.counter.set(reader.readLong());
    }

    @Override
    public void set(long value) {
        this.counter.set(value);
    }

    @Override
    public long get() {
        return this.counter.get();
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return this.counter.compareAndSet(expect, update);
    }

    @Override
    public long incrementAndGet() {
        return this.counter.incrementAndGet();
    }

    @Override
    public long getAndIncrement() {
        return this.counter.getAndIncrement();
    }

    @Override
    public long decrementAndGet() {
        return this.counter.decrementAndGet();
    }

    @Override
    public long getAndDecrement() {
        return this.counter.getAndDecrement();
    }

    @Override
    public long addAndGet(long delta) {
        return this.counter.addAndGet(delta);
    }

    @Override
    public long getAndAdd(long delta) {
        return this.counter.getAndAdd(delta);
    }
}

