/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import io.atomix.core.election.AsyncLeaderElector;
import io.atomix.core.election.LeaderElector;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.Synchronous;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class BlockingLeaderElector<T>
extends Synchronous<AsyncLeaderElector<T>>
implements LeaderElector<T> {
    private final AsyncLeaderElector<T> asyncElector;
    private final long operationTimeoutMillis;

    public BlockingLeaderElector(AsyncLeaderElector<T> asyncElector, long operationTimeoutMillis) {
        super(asyncElector);
        this.asyncElector = asyncElector;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Leadership<T> run(String topic, T identifier) {
        return this.complete(this.asyncElector.run(topic, identifier));
    }

    @Override
    public void withdraw(String topic, T identifier) {
        this.complete(this.asyncElector.withdraw(topic, identifier));
    }

    @Override
    public boolean anoint(String topic, T identifier) {
        return this.complete(this.asyncElector.anoint(topic, identifier));
    }

    @Override
    public boolean promote(String topic, T identifier) {
        return this.complete(this.asyncElector.promote(topic, identifier));
    }

    @Override
    public void evict(T identifier) {
        this.complete(this.asyncElector.evict(identifier));
    }

    @Override
    public Leadership<T> getLeadership(String topic) {
        return this.complete(this.asyncElector.getLeadership(topic));
    }

    @Override
    public Map<String, Leadership<T>> getLeaderships() {
        return this.complete(this.asyncElector.getLeaderships());
    }

    @Override
    public void addListener(LeadershipEventListener<T> listener) {
        this.complete(this.asyncElector.addListener(listener));
    }

    @Override
    public void removeListener(LeadershipEventListener<T> listener) {
        this.complete(this.asyncElector.removeListener(listener));
    }

    @Override
    public void addListener(String topic, LeadershipEventListener<T> listener) {
        this.complete(this.asyncElector.addListener(topic, listener));
    }

    @Override
    public void removeListener(String topic, LeadershipEventListener<T> listener) {
        this.complete(this.asyncElector.removeListener(topic, listener));
    }

    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncElector.addStateChangeListener(listener);
    }

    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncElector.removeStateChangeListener(listener);
    }

    @Override
    public AsyncLeaderElector<T> async() {
        return this.asyncElector;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }
}

