/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.iterator.impl;

import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.CloseFunction;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.iterator.impl.NextFunction;
import io.atomix.core.iterator.impl.OpenFunction;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.OrderedFuture;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ProxyIterator<S, T>
implements AsyncIterator<T> {
    private final ProxyClient<S> client;
    private final PartitionId partitionId;
    private final NextFunction<S, T> nextFunction;
    private final CloseFunction<S> closeFunction;
    private final CompletableFuture<Long> openFuture;
    private volatile CompletableFuture<IteratorBatch<T>> batch;
    private volatile CompletableFuture<Void> closeFuture;

    public ProxyIterator(ProxyClient<S> client, PartitionId partitionId, OpenFunction<S> openFunction, NextFunction<S, T> nextFunction, CloseFunction<S> closeFunction) {
        this.client = client;
        this.partitionId = partitionId;
        this.nextFunction = nextFunction;
        this.closeFunction = closeFunction;
        this.openFuture = OrderedFuture.wrap((CompletableFuture)client.applyOn(partitionId, openFunction::open));
        this.batch = CompletableFuture.completedFuture(new IteratorBatch(0, Collections.emptyList()));
    }

    private CompletableFuture<Iterator<T>> batch() {
        return this.batch.thenCompose(iterator -> {
            if (iterator != null && !iterator.hasNext()) {
                this.batch = this.fetch(iterator.position());
                return this.batch.thenApply(Function.identity());
            }
            return CompletableFuture.completedFuture(iterator);
        });
    }

    private CompletableFuture<IteratorBatch<T>> fetch(int position) {
        return this.openFuture.thenCompose(id -> this.client.applyOn(this.partitionId, service -> this.nextFunction.next(service, (long)id, position)).thenCompose(batch -> {
            if (batch == null) {
                return this.close().thenApply(v -> null);
            }
            return CompletableFuture.completedFuture(batch);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close() {
        if (this.closeFuture == null) {
            ProxyIterator proxyIterator = this;
            synchronized (proxyIterator) {
                if (this.closeFuture == null) {
                    this.closeFuture = this.openFuture.thenCompose(id -> this.client.acceptOn(this.partitionId, service -> this.closeFunction.close(service, (long)id)));
                }
            }
        }
        return this.closeFuture;
    }

    @Override
    public CompletableFuture<Boolean> hasNext() {
        return this.batch().thenApply(iterator -> iterator != null && iterator.hasNext());
    }

    @Override
    public CompletableFuture<T> next() {
        return this.batch().thenCompose(iterator -> {
            if (iterator == null) {
                return Futures.exceptionalFuture((Throwable)new NoSuchElementException());
            }
            return CompletableFuture.completedFuture(iterator.next());
        });
    }
}

