/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.list.impl;

import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.collection.impl.DefaultDistributedCollectionService;
import io.atomix.core.list.DistributedListType;
import io.atomix.core.list.impl.DistributedListService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DefaultDistributedListService
extends DefaultDistributedCollectionService<List<String>, String>
implements DistributedListService {
    public DefaultDistributedListService() {
        super(DistributedListType.instance(), Collections.synchronizedList(new ArrayList()));
    }

    private List<String> list() {
        return (List)this.collection();
    }

    @Override
    public CollectionUpdateResult<Boolean> addAll(int index, Collection<? extends String> c) {
        boolean changed = false;
        for (String string : c) {
            if (this.add(string).status() != CollectionUpdateResult.Status.OK) continue;
            changed = true;
        }
        return CollectionUpdateResult.ok(changed);
    }

    @Override
    public String get(int index) {
        return this.list().get(index);
    }

    @Override
    public CollectionUpdateResult<String> set(int index, String element) {
        try {
            String value = this.list().set(index, element);
            if (value != null) {
                this.removed(value);
            }
            this.added(element);
            return CollectionUpdateResult.ok(value);
        }
        catch (IndexOutOfBoundsException e) {
            return CollectionUpdateResult.noop();
        }
    }

    @Override
    public CollectionUpdateResult<Void> add(int index, String element) {
        try {
            this.list().add(index, element);
            this.added(element);
            return CollectionUpdateResult.ok();
        }
        catch (IndexOutOfBoundsException e) {
            return CollectionUpdateResult.noop();
        }
    }

    @Override
    public CollectionUpdateResult<String> remove(int index) {
        try {
            String value = this.list().remove(index);
            if (value != null) {
                this.removed(value);
            }
            return CollectionUpdateResult.ok(value);
        }
        catch (IndexOutOfBoundsException e) {
            return CollectionUpdateResult.noop();
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.list().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list().lastIndexOf(o);
    }
}

