/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.Sets;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.primitive.resource.PrimitiveResource;
import io.atomix.utils.time.Versioned;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicMapResource
implements PrimitiveResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicMapResource.class);
    private final AsyncAtomicMap<String, String> map;

    public AtomicMapResource(AsyncAtomicMap<String, String> map) {
        this.map = map;
    }

    @GET
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public void get(@PathParam(value="key") String key, @Suspended AsyncResponse response) {
        this.map.get(key).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/{key}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public void put(@PathParam(value="key") String key, String value, @Suspended AsyncResponse response) {
        this.map.put(key, value).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public void remove(@PathParam(value="key") String key, @Suspended AsyncResponse response) {
        this.map.remove(key).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/keys")
    @Produces(value={"application/json"})
    public void keys(@Suspended AsyncResponse response) {
        response.resume((Object)Response.ok((Object)Sets.newHashSet(this.map.keySet().iterator().sync())).build());
    }

    @GET
    @Path(value="/size")
    @Produces(value={"application/json"})
    public void size(@Suspended AsyncResponse response) {
        this.map.size().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/clear")
    public void clear(@Suspended AsyncResponse response) {
        this.map.clear().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.noContent().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class VersionedResult {
        private final Versioned<String> value;

        public VersionedResult(Versioned<String> value) {
            this.value = value;
        }

        public String getValue() {
            return (String)this.value.value();
        }

        public long getVersion() {
            return this.value.version();
        }
    }
}

