/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.Maps;
import io.atomix.core.map.AsyncAtomicNavigableMap;
import io.atomix.core.map.AsyncDistributedNavigableMap;
import io.atomix.core.map.DistributedNavigableMap;
import io.atomix.core.map.DistributedNavigableMapType;
import io.atomix.core.map.impl.BlockingDistributedNavigableMap;
import io.atomix.core.map.impl.DelegatingAsyncDistributedSortedMap;
import io.atomix.core.set.AsyncDistributedNavigableSet;
import io.atomix.primitive.PrimitiveType;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DelegatingAsyncDistributedNavigableMap<K extends Comparable<K>, V>
extends DelegatingAsyncDistributedSortedMap<K, V>
implements AsyncDistributedNavigableMap<K, V> {
    private final AsyncAtomicNavigableMap<K, V> atomicMap;

    public DelegatingAsyncDistributedNavigableMap(AsyncAtomicNavigableMap<K, V> atomicMap) {
        super(atomicMap);
        this.atomicMap = atomicMap;
    }

    private Map.Entry<K, V> convertEntry(Map.Entry<K, Versioned<V>> entry) {
        return entry == null ? null : Maps.immutableEntry(entry.getKey(), (Object)Versioned.valueOrNull(entry.getValue()));
    }

    @Override
    public PrimitiveType type() {
        return DistributedNavigableMapType.instance();
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> lowerEntry(K key) {
        return this.atomicMap.lowerEntry(key).thenApply(this::convertEntry);
    }

    @Override
    public CompletableFuture<K> lowerKey(K key) {
        return this.atomicMap.lowerKey(key);
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> floorEntry(K key) {
        return this.atomicMap.floorEntry(key).thenApply(this::convertEntry);
    }

    @Override
    public CompletableFuture<K> floorKey(K key) {
        return this.atomicMap.floorKey(key);
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> ceilingEntry(K key) {
        return this.atomicMap.ceilingEntry(key).thenApply(this::convertEntry);
    }

    @Override
    public CompletableFuture<K> ceilingKey(K key) {
        return this.atomicMap.ceilingKey(key);
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> higherEntry(K key) {
        return this.atomicMap.higherEntry(key).thenApply(this::convertEntry);
    }

    @Override
    public CompletableFuture<K> higherKey(K key) {
        return this.atomicMap.higherKey(key);
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> firstEntry() {
        return this.atomicMap.firstEntry().thenApply(this::convertEntry);
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> lastEntry() {
        return this.atomicMap.lastEntry().thenApply(this::convertEntry);
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> pollFirstEntry() {
        return this.atomicMap.pollFirstEntry().thenApply(this::convertEntry);
    }

    @Override
    public CompletableFuture<Map.Entry<K, V>> pollLastEntry() {
        return this.atomicMap.pollLastEntry().thenApply(this::convertEntry);
    }

    @Override
    public AsyncDistributedNavigableMap<K, V> descendingMap() {
        return new DelegatingAsyncDistributedNavigableMap<K, V>(this.atomicMap.descendingMap());
    }

    @Override
    public AsyncDistributedNavigableSet<K> navigableKeySet() {
        return this.atomicMap.navigableKeySet();
    }

    @Override
    public AsyncDistributedNavigableSet<K> descendingKeySet() {
        return this.atomicMap.descendingKeySet();
    }

    @Override
    public AsyncDistributedNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new DelegatingAsyncDistributedNavigableMap<K, V>(this.atomicMap.subMap(fromKey, fromInclusive, toKey, toInclusive));
    }

    @Override
    public AsyncDistributedNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new DelegatingAsyncDistributedNavigableMap<K, V>(this.atomicMap.headMap(toKey, inclusive));
    }

    @Override
    public AsyncDistributedNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new DelegatingAsyncDistributedNavigableMap<K, V>(this.atomicMap.tailMap(fromKey, inclusive));
    }

    @Override
    public DistributedNavigableMap<K, V> sync(Duration timeout) {
        return new BlockingDistributedNavigableMap(this, timeout.toMillis());
    }
}

