/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.base.Throwables;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.impl.BlockingDistributedMap;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.impl.BlockingDistributedMultiset;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import io.atomix.utils.time.Versioned;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingAtomicMultimap<K, V>
extends Synchronous<AsyncAtomicMultimap<K, V>>
implements AtomicMultimap<K, V> {
    private final AsyncAtomicMultimap<K, V> asyncMultimap;
    private final long operationTimeoutMillis;

    public BlockingAtomicMultimap(AsyncAtomicMultimap<K, V> asyncMultimap, long operationTimeoutMillis) {
        super(asyncMultimap);
        this.asyncMultimap = asyncMultimap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncMultimap.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncMultimap.isEmpty());
    }

    @Override
    public boolean containsKey(K key) {
        return this.complete(this.asyncMultimap.containsKey(key));
    }

    @Override
    public boolean containsValue(V value) {
        return this.complete(this.asyncMultimap.containsValue(value));
    }

    @Override
    public boolean containsEntry(K key, V value) {
        return this.complete(this.asyncMultimap.containsEntry(key, value));
    }

    @Override
    public boolean put(K key, V value) {
        return this.complete(this.asyncMultimap.put(key, value));
    }

    @Override
    public boolean remove(K key, V value) {
        return this.complete(this.asyncMultimap.remove(key, value));
    }

    @Override
    public boolean removeAll(K key, Collection<? extends V> values) {
        return this.complete(this.asyncMultimap.removeAll(key, values));
    }

    @Override
    public Versioned<Collection<V>> removeAll(K key) {
        return this.complete(this.asyncMultimap.removeAll(key));
    }

    @Override
    public boolean putAll(K key, Collection<? extends V> values) {
        return this.complete(this.asyncMultimap.putAll(key, values));
    }

    @Override
    public Versioned<Collection<V>> replaceValues(K key, Collection<V> values) {
        return this.complete(this.asyncMultimap.replaceValues(key, values));
    }

    @Override
    public void clear() {
        this.complete(this.asyncMultimap.clear());
    }

    @Override
    public Versioned<Collection<V>> get(K key) {
        return this.complete(this.asyncMultimap.get(key));
    }

    @Override
    public DistributedSet<K> keySet() {
        return new BlockingDistributedSet<K>(this.asyncMultimap.keySet(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedMultiset<K> keys() {
        return new BlockingDistributedMultiset<K>(this.asyncMultimap.keys(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedMultiset<V> values() {
        return new BlockingDistributedMultiset<V>(this.asyncMultimap.values(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedCollection<Map.Entry<K, V>> entries() {
        return new BlockingDistributedCollection<Map.Entry<K, V>>(this.asyncMultimap.entries(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedMap<K, Versioned<Collection<V>>> asMap() {
        return new BlockingDistributedMap<K, Versioned<Collection<V>>>(this.asyncMultimap.asMap(), this.operationTimeoutMillis);
    }

    @Override
    public void addListener(AtomicMultimapEventListener<K, V> listener, Executor executor) {
        this.complete(this.asyncMultimap.addListener(listener, executor));
    }

    @Override
    public void removeListener(AtomicMultimapEventListener<K, V> listener) {
        this.complete(this.asyncMultimap.removeListener(listener));
    }

    @Override
    public AsyncAtomicMultimap<K, V> async() {
        return this.asyncMultimap;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new PrimitiveException(e.getCause());
        }
    }
}

