/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.queue.impl;

import io.atomix.core.collection.impl.DistributedCollectionResource;
import io.atomix.core.queue.AsyncDistributedQueue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueueResource
extends DistributedCollectionResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedQueueResource.class);
    private final AsyncDistributedQueue<String> queue;

    public DistributedQueueResource(AsyncDistributedQueue<String> queue) {
        super(queue);
        this.queue = queue;
    }

    @POST
    @Path(value="/remove")
    @Produces(value={"application/json"})
    public void remove(@Suspended AsyncResponse response) {
        this.queue.remove().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/poll")
    @Produces(value={"application/json"})
    public void poll(@Suspended AsyncResponse response) {
        this.queue.poll().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/element")
    @Produces(value={"application/json"})
    public void element(@Suspended AsyncResponse response) {
        this.queue.element().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/peek")
    @Produces(value={"application/json"})
    public void peek(@Suspended AsyncResponse response) {
        this.queue.peek().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

