/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set;

import com.google.common.base.MoreObjects;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.DistributedNavigableSetBuilder;
import io.atomix.core.set.DistributedNavigableSetConfig;
import io.atomix.core.set.impl.DefaultDistributedNavigableSetBuilder;
import io.atomix.core.set.impl.DefaultDistributedNavigableSetService;
import io.atomix.core.set.impl.DistributedSetResource;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.CommitResult;
import io.atomix.core.transaction.impl.PrepareResult;
import io.atomix.core.transaction.impl.RollbackResult;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.resource.PrimitiveResource;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;

public class DistributedNavigableSetType<E extends Comparable<E>>
implements PrimitiveType<DistributedNavigableSetBuilder<E>, DistributedNavigableSetConfig, DistributedNavigableSet<E>> {
    private static final String NAME = "navigable-set";
    private static final DistributedNavigableSetType INSTANCE = new DistributedNavigableSetType();

    public static <E extends Comparable<E>> DistributedNavigableSetType<E> instance() {
        return INSTANCE;
    }

    public String name() {
        return NAME;
    }

    public Namespace namespace() {
        return Namespace.builder().register(super.namespace()).register(Namespaces.BASIC).nextId(500).register(new Class[]{CollectionUpdateResult.class}).register(new Class[]{CollectionUpdateResult.Status.class}).register(new Class[]{CollectionEvent.class}).register(new Class[]{CollectionEvent.Type.class}).register(new Class[]{IteratorBatch.class}).register(new Class[]{TransactionId.class}).register(new Class[]{TransactionLog.class}).register(new Class[]{SetUpdate.class}).register(new Class[]{SetUpdate.Type.class}).register(new Class[]{PrepareResult.class}).register(new Class[]{CommitResult.class}).register(new Class[]{RollbackResult.class}).build();
    }

    public PrimitiveService newService(ServiceConfig config) {
        return new DefaultDistributedNavigableSetService();
    }

    public PrimitiveResource newResource(DistributedNavigableSet<E> primitive) {
        return new DistributedSetResource(primitive.async());
    }

    public DistributedNavigableSetConfig newConfig() {
        return new DistributedNavigableSetConfig();
    }

    public DistributedNavigableSetBuilder<E> newBuilder(String name, DistributedNavigableSetConfig config, PrimitiveManagementService managementService) {
        return new DefaultDistributedNavigableSetBuilder(name, config, managementService);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).toString();
    }
}

