/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.AsyncJavaIterator;
import io.atomix.core.set.AsyncDistributedNavigableSet;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.impl.AsyncDistributedSortedJavaSet;
import io.atomix.core.set.impl.BlockingDistributedNavigableSet;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.time.Duration;
import java.util.NavigableSet;
import java.util.concurrent.CompletableFuture;

public class AsyncDistributedNavigableJavaSet<E extends Comparable<E>>
extends AsyncDistributedSortedJavaSet<E>
implements AsyncDistributedNavigableSet<E> {
    private final NavigableSet<E> set;

    public AsyncDistributedNavigableJavaSet(String name, PrimitiveProtocol protocol, NavigableSet<E> set) {
        super(name, protocol, set);
        this.set = set;
    }

    @Override
    public CompletableFuture<E> lower(E e) {
        return CompletableFuture.completedFuture(this.set.lower(e));
    }

    @Override
    public CompletableFuture<E> floor(E e) {
        return CompletableFuture.completedFuture(this.set.floor(e));
    }

    @Override
    public CompletableFuture<E> ceiling(E e) {
        return CompletableFuture.completedFuture(this.set.ceiling(e));
    }

    @Override
    public CompletableFuture<E> higher(E e) {
        return CompletableFuture.completedFuture(this.set.higher(e));
    }

    @Override
    public CompletableFuture<E> pollFirst() {
        return CompletableFuture.completedFuture(this.set.pollFirst());
    }

    @Override
    public CompletableFuture<E> pollLast() {
        return CompletableFuture.completedFuture(this.set.pollLast());
    }

    @Override
    public AsyncDistributedNavigableSet<E> descendingSet() {
        return new AsyncDistributedNavigableJavaSet<E>(this.name(), this.protocol(), this.set.descendingSet());
    }

    @Override
    public AsyncIterator<E> descendingIterator() {
        return new AsyncJavaIterator<E>(this.set.descendingIterator());
    }

    @Override
    public AsyncDistributedNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new AsyncDistributedNavigableJavaSet<E>(this.name(), this.protocol(), this.set.subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public AsyncDistributedNavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new AsyncDistributedNavigableJavaSet<E>(this.name(), this.protocol(), this.set.headSet(toElement, inclusive));
    }

    @Override
    public AsyncDistributedNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new AsyncDistributedNavigableJavaSet<E>(this.name(), this.protocol(), this.set.tailSet(fromElement, inclusive));
    }

    @Override
    public DistributedNavigableSet<E> sync(Duration operationTimeout) {
        return new BlockingDistributedNavigableSet(this, operationTimeout.toMillis());
    }
}

