/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEvent;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.core.tree.IllegalDocumentModificationException;
import io.atomix.core.tree.NoSuchDocumentPathException;
import io.atomix.core.tree.impl.BlockingAtomicDocumentTree;
import io.atomix.core.tree.impl.DocumentTreeClient;
import io.atomix.core.tree.impl.DocumentTreeResult;
import io.atomix.core.tree.impl.DocumentTreeService;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class AtomicDocumentTreeProxy
extends AbstractAsyncPrimitive<AsyncAtomicDocumentTree<byte[]>, DocumentTreeService>
implements AsyncAtomicDocumentTree<byte[]>,
DocumentTreeClient {
    private final Map<DocumentTreeEventListener<byte[]>, InternalListener> eventListeners = new HashMap<DocumentTreeEventListener<byte[]>, InternalListener>();

    public AtomicDocumentTreeProxy(ProxyClient<DocumentTreeService> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    @Override
    public DocumentPath root() {
        return DocumentPath.ROOT;
    }

    @Override
    public CompletableFuture<Map<String, Versioned<byte[]>>> getChildren(DocumentPath path) {
        return this.getProxyClient().applyBy(this.name(), service -> service.getChildren(path)).thenApply(result -> result.status() == DocumentTreeResult.Status.OK ? (Map)result.result() : ImmutableMap.of());
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> get(DocumentPath path) {
        return this.getProxyClient().applyBy(this.name(), service -> service.get(path));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> set(DocumentPath path, byte[] value) {
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.set(path, value)).thenCompose(result -> {
            if (result.status() == DocumentTreeResult.Status.INVALID_PATH) {
                return Futures.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeResult.Status.ILLEGAL_MODIFICATION) {
                return Futures.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result);
        })).thenApply(result -> (Versioned)result.result());
    }

    @Override
    public CompletableFuture<Boolean> create(DocumentPath path, byte[] value) {
        return this.getProxyClient().applyBy(this.name(), service -> service.create(path, value)).thenCompose(result -> {
            if (result.status() == DocumentTreeResult.Status.INVALID_PATH) {
                return Futures.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeResult.Status.ILLEGAL_MODIFICATION) {
                return Futures.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result.status() == DocumentTreeResult.Status.OK);
        });
    }

    @Override
    public CompletableFuture<Boolean> createRecursive(DocumentPath path, byte[] value) {
        return this.getProxyClient().applyBy(this.name(), service -> service.createRecursive(path, value)).thenCompose(result -> {
            if (result.status() == DocumentTreeResult.Status.INVALID_PATH) {
                return Futures.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeResult.Status.ILLEGAL_MODIFICATION) {
                return Futures.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result.status() == DocumentTreeResult.Status.OK);
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(DocumentPath path, byte[] newValue, long version) {
        return this.getProxyClient().applyBy(this.name(), service -> service.replace(path, newValue, version)).thenCompose(result -> {
            if (result.status() == DocumentTreeResult.Status.INVALID_PATH) {
                return Futures.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeResult.Status.ILLEGAL_MODIFICATION) {
                return Futures.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result.status() == DocumentTreeResult.Status.OK);
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(DocumentPath path, byte[] newValue, byte[] currentValue) {
        return this.getProxyClient().applyBy(this.name(), service -> service.replace(path, newValue, currentValue)).thenCompose(result -> {
            if (result.status() == DocumentTreeResult.Status.INVALID_PATH) {
                return Futures.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeResult.Status.ILLEGAL_MODIFICATION) {
                return Futures.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result.status() == DocumentTreeResult.Status.OK);
        });
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> removeNode(DocumentPath path) {
        if (path.equals(this.root())) {
            return Futures.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
        }
        return ((CompletableFuture)this.getProxyClient().applyBy(this.name(), service -> service.removeNode(path)).thenCompose(result -> {
            if (result.status() == DocumentTreeResult.Status.INVALID_PATH) {
                return Futures.exceptionalFuture((Throwable)new NoSuchDocumentPathException());
            }
            if (result.status() == DocumentTreeResult.Status.ILLEGAL_MODIFICATION) {
                return Futures.exceptionalFuture((Throwable)new IllegalDocumentModificationException());
            }
            return CompletableFuture.completedFuture(result);
        })).thenApply(result -> (Versioned)result.result());
    }

    @Override
    public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeEventListener<byte[]> listener, Executor executor) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(listener);
        InternalListener internalListener = new InternalListener(path, listener, executor);
        if (!this.eventListeners.containsKey(listener)) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.listen(path)).thenRun(() -> this.eventListeners.put(listener, internalListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(DocumentTreeEventListener<byte[]> listener) {
        Preconditions.checkNotNull(listener);
        InternalListener internalListener = this.eventListeners.remove(listener);
        if (internalListener != null && this.eventListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.unlisten(internalListener.path));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<AsyncAtomicDocumentTree<byte[]>> connect() {
        return ((CompletableFuture)super.connect().thenRun(() -> this.getProxyClient().getPartition(this.name()).addStateChangeListener(state -> {
            if (state == PrimitiveState.CONNECTED && this.isListening()) {
                this.getProxyClient().acceptBy(this.name(), service -> service.listen(this.root()));
            }
        }))).thenApply(v -> this);
    }

    public CompletableFuture<Void> delete() {
        return this.getProxyClient().acceptBy(this.name(), service -> service.clear());
    }

    @Override
    public AtomicDocumentTree<byte[]> sync(Duration operationTimeout) {
        return new BlockingAtomicDocumentTree<byte[]>(this, operationTimeout.toMillis());
    }

    private boolean isListening() {
        return !this.eventListeners.isEmpty();
    }

    @Override
    public void change(DocumentTreeEvent<byte[]> event) {
        this.eventListeners.values().forEach(listener -> listener.event(event));
    }

    private static class InternalListener
    implements DocumentTreeEventListener<byte[]> {
        private final DocumentPath path;
        private final DocumentTreeEventListener<byte[]> listener;
        private final Executor executor;

        public InternalListener(DocumentPath path, DocumentTreeEventListener<byte[]> listener, Executor executor) {
            this.path = path;
            this.listener = listener;
            this.executor = executor;
        }

        public void event(DocumentTreeEvent<byte[]> event) {
            if (event.path().isDescendentOf(this.path)) {
                this.executor.execute(() -> this.listener.event((Event)event));
            }
        }
    }
}

