/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Label {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    private Map<String, String> properties = new HashMap<String, String>();

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="")
    public String getOrgID() {
        return this.orgID;
    }

    public Label name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Label properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Label putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(example="{\"color\":\"ffb3b3\",\"description\":\"this is a description\"}", value="Key/Value pairs associated with this label. Keys can be removed by sending an update with an empty value.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        return Objects.equals(this.id, label.id) && Objects.equals(this.orgID, label.orgID) && Objects.equals(this.name, label.name) && Objects.equals(this.properties, label.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.orgID, this.name, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Label {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

