/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class LineProtocolLengthError {
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private CodeEnum code = CodeEnum.INVALID;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_MAX_LENGTH = "maxLength";
    @SerializedName(value="maxLength")
    private Integer maxLength;

    @ApiModelProperty(required=true, value="Code is the machine-readable error code.")
    public CodeEnum getCode() {
        return this.code;
    }

    @ApiModelProperty(required=true, value="Message is a human-readable message.")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(required=true, value="Max length in bytes for a body of line-protocol.")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineProtocolLengthError lineProtocolLengthError = (LineProtocolLengthError)o;
        return Objects.equals((Object)this.code, (Object)lineProtocolLengthError.code) && Objects.equals(this.message, lineProtocolLengthError.message) && Objects.equals(this.maxLength, lineProtocolLengthError.maxLength);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message, this.maxLength});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineProtocolLengthError {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CodeEnum {
        INVALID("invalid");

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CodeEnum fromValue(String text) {
            for (CodeEnum b : CodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CodeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, CodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public CodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CodeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

