/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.Filter;
import java.math.BigDecimal;
import java.math.BigInteger;

@JinjavaDoc(value="Multiplies the current object with the given multiplier", input={@JinjavaParam(value="value", type="number", desc="Base number to be multiplied", required=true)}, params={@JinjavaParam(value="multiplier", type="number", desc="The multiplier", required=true)}, snippets={@JinjavaSnippet(code="{% set n = 20 %}\n{{ n|multiply(3) }}")})
public class MultiplyFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        BigDecimal num;
        if (arg.length < 1) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires 1 argument (number to multiply by)");
        }
        String toMul = arg[0];
        try {
            num = new BigDecimal(toMul);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.NUMBER_FORMAT, 0, toMul);
        }
        if (object instanceof Integer) {
            return ((Number)num).intValue() * (Integer)object;
        }
        if (object instanceof Float) {
            return 0.0 + (double)(((Number)num).floatValue() * ((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return ((Number)num).longValue() * (Long)object;
        }
        if (object instanceof Short) {
            return 0 + num.shortValue() * (Short)object;
        }
        if (object instanceof Double) {
            return ((Number)num).doubleValue() * (Double)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).multiply(BigDecimal.valueOf(((Number)num).doubleValue()));
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).multiply(BigInteger.valueOf(((Number)num).longValue()));
        }
        if (object instanceof Byte) {
            return num.byteValue() * (Byte)object;
        }
        if (object instanceof String) {
            try {
                return ((Number)num).doubleValue() * Double.parseDouble((String)object);
            }
            catch (NumberFormatException e) {
                throw new InvalidInputException(interpreter, this, InvalidReason.NUMBER_FORMAT, object.toString());
            }
        }
        return object;
    }

    @Override
    public String getName() {
        return "multiply";
    }
}

