/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.DryRunable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.GenericKubernetesResourceOperationsImpl;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.Scope;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

public class RawCustomResourceOperationsImpl
implements Nameable<RawCustomResourceOperationsImpl>,
Namespaceable<RawCustomResourceOperationsImpl>,
AnyNamespaceable<RawCustomResourceOperationsImpl>,
Listable<Map<String, Object>>,
Gettable<Map<String, Object>>,
GracePeriodConfigurable<RawCustomResourceOperationsImpl>,
PropagationPolicyConfigurable<RawCustomResourceOperationsImpl>,
DryRunable<RawCustomResourceOperationsImpl>,
Deletable {
    private final GenericKubernetesResourceOperationsImpl delegate;
    private final CustomResourceDefinitionContext customResourceDefinition;

    private RawCustomResourceOperationsImpl(GenericKubernetesResourceOperationsImpl delegate, CustomResourceDefinitionContext crdContext) {
        this.delegate = delegate;
        this.customResourceDefinition = crdContext;
    }

    public RawCustomResourceOperationsImpl(ClientContext clientContext, CustomResourceDefinitionContext customResourceDefinition) {
        this(new GenericKubernetesResourceOperationsImpl(new OperationContext().withHttpClient(clientContext.getHttpClient()).withConfig((Config)clientContext.getConfiguration()).withNamespace(null).withName(null).withGracePeriodSeconds(-1L).withCascading(false).withDryRun(false).withPropagationPolicy(HasMetadataOperation.DEFAULT_PROPAGATION_POLICY).withApiGroupName(customResourceDefinition.getGroup()).withApiGroupVersion(customResourceDefinition.getVersion()).withPlural(customResourceDefinition.getPlural()), Scope.NAMESPACED.value().equals(customResourceDefinition.getScope())), customResourceDefinition);
    }

    @Override
    public RawCustomResourceOperationsImpl withName(String name) {
        return new RawCustomResourceOperationsImpl((GenericKubernetesResourceOperationsImpl)this.delegate.withName(name), this.customResourceDefinition);
    }

    @Override
    public RawCustomResourceOperationsImpl inNamespace(String namespace) {
        return new RawCustomResourceOperationsImpl((GenericKubernetesResourceOperationsImpl)this.delegate.inNamespace(namespace), this.customResourceDefinition);
    }

    @Override
    public RawCustomResourceOperationsImpl inAnyNamespace() {
        return new RawCustomResourceOperationsImpl((GenericKubernetesResourceOperationsImpl)this.delegate.inAnyNamespace(), this.customResourceDefinition);
    }

    @Override
    public RawCustomResourceOperationsImpl withGracePeriod(long gracePeriodSeconds) {
        return new RawCustomResourceOperationsImpl((GenericKubernetesResourceOperationsImpl)this.delegate.withGracePeriod(gracePeriodSeconds), this.customResourceDefinition);
    }

    @Override
    public RawCustomResourceOperationsImpl withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new RawCustomResourceOperationsImpl((GenericKubernetesResourceOperationsImpl)this.delegate.withPropagationPolicy(propagationPolicy), this.customResourceDefinition);
    }

    @Override
    public RawCustomResourceOperationsImpl dryRun(boolean isDryRun) {
        return new RawCustomResourceOperationsImpl((GenericKubernetesResourceOperationsImpl)this.delegate.dryRun(isDryRun), this.customResourceDefinition);
    }

    public Config getConfig() {
        return this.delegate.getConfig();
    }

    private RawCustomResourceOperationsImpl withDeleteOptions(DeleteOptions deleteOptions) {
        return new RawCustomResourceOperationsImpl((GenericKubernetesResourceOperationsImpl)this.delegate.withGracePeriod(this.resolveGracePeriod(deleteOptions.getGracePeriodSeconds())).withPropagationPolicy(this.resolvePropagationPolicy(deleteOptions.getPropagationPolicy())), this.customResourceDefinition);
    }

    public Map<String, Object> load(InputStream inputStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.load(inputStream).get());
    }

    public Map<String, Object> load(String objectAsJsonString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.load(new ByteArrayInputStream(objectAsJsonString.getBytes(StandardCharsets.UTF_8))).get());
    }

    public Map<String, Object> create(String objectAsString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.create(Serialization.jsonMapper().readValue(objectAsString, GenericKubernetesResource.class)));
    }

    public Map<String, Object> create(Map<String, Object> object) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.create(Serialization.jsonMapper().convertValue(object, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> create(String namespace, String objectAsString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.inNamespace(namespace).create(Serialization.unmarshal(objectAsString, GenericKubernetesResource.class)));
    }

    public Map<String, Object> create(InputStream objectAsStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.create(Serialization.unmarshal(objectAsStream, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> create(String namespace, InputStream objectAsStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.inNamespace(namespace).create(Serialization.unmarshal(objectAsStream, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> create(String namespace, Map<String, Object> object) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.inNamespace(namespace).create(Serialization.jsonMapper().convertValue(object, GenericKubernetesResource.class)));
    }

    public Map<String, Object> createOrReplace(String objectAsString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.createOrReplace(new GenericKubernetesResource[]{Serialization.unmarshal(objectAsString, GenericKubernetesResource.class)}));
    }

    public Map<String, Object> createOrReplace(Map<String, Object> customResourceObject) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.createOrReplace(new GenericKubernetesResource[]{Serialization.jsonMapper().convertValue(customResourceObject, GenericKubernetesResource.class)}));
    }

    public Map<String, Object> createOrReplace(InputStream inputStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.createOrReplace(new GenericKubernetesResource[]{Serialization.unmarshal(inputStream, GenericKubernetesResource.class)}));
    }

    @Deprecated
    public Map<String, Object> createOrReplace(String namespace, String objectAsString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(this.delegate.inNamespace(namespace).createOrReplace(Serialization.unmarshal(objectAsString, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> createOrReplace(String namespace, Map<String, Object> customResourceObject) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(this.delegate.inNamespace(namespace).createOrReplace(Serialization.jsonMapper().convertValue(customResourceObject, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> createOrReplace(String namespace, InputStream objectAsStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(this.delegate.inNamespace(namespace).createOrReplace(Serialization.unmarshal(objectAsStream, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> edit(String name, Map<String, Object> object) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.withName(name).edit(gkr -> Serialization.jsonMapper().convertValue((Object)object, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> edit(String name, String objectAsString) throws IOException {
        GenericKubernetesResource edited = Serialization.jsonMapper().readValue(objectAsString, GenericKubernetesResource.class);
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.withName(name).edit(gkr -> edited));
    }

    @Deprecated
    public Map<String, Object> edit(String namespace, String name, Map<String, Object> object) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)((Resource)this.delegate.inNamespace(namespace).withName(name)).edit(gkr -> Serialization.jsonMapper().convertValue((Object)object, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> edit(String namespace, String name, String objectAsString) throws IOException {
        GenericKubernetesResource edited = Serialization.jsonMapper().readValue(objectAsString, GenericKubernetesResource.class);
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)((Resource)this.delegate.inNamespace(namespace).withName(name)).edit(gkr -> edited));
    }

    public Map<String, Object> edit(String objectAsString) throws IOException {
        GenericKubernetesResource edited = Serialization.jsonMapper().readValue(objectAsString, GenericKubernetesResource.class);
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.edit(gkr -> edited));
    }

    public Map<String, Object> edit(Map<String, Object> object) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.edit(gkr -> Serialization.jsonMapper().convertValue((Object)object, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> updateStatus(String name, Map<String, Object> objectAsMap) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(this.delegate.withName(name).updateStatus(Serialization.jsonMapper().convertValue(objectAsMap, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> updateStatus(String name, String objectAsJsonString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(this.delegate.withName(name).updateStatus(Serialization.unmarshal(objectAsJsonString, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> updateStatus(String namespace, String name, Map<String, Object> objectAsMap) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(((Resource)this.delegate.inNamespace(namespace).withName(name)).updateStatus(Serialization.jsonMapper().convertValue(objectAsMap, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> updateStatus(String name, InputStream objectAsStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(this.delegate.withName(name).updateStatus(Serialization.unmarshal(objectAsStream, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> updateStatus(String namespace, String name, InputStream objectAsStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(((Resource)this.delegate.inNamespace(namespace).withName(name)).updateStatus(Serialization.unmarshal(objectAsStream, GenericKubernetesResource.class)));
    }

    @Deprecated
    public Map<String, Object> updateStatus(String namespace, String name, String objectAsJsonString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap(((Resource)this.delegate.inNamespace(namespace).withName(name)).updateStatus(Serialization.unmarshal(objectAsJsonString, GenericKubernetesResource.class)));
    }

    public Map<String, Object> updateStatus(String objectAsJsonString) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.updateStatus((HasMetadata)Serialization.unmarshal(objectAsJsonString, GenericKubernetesResource.class)));
    }

    public Map<String, Object> updateStatus(Map<String, Object> objectAsMap) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.updateStatus((HasMetadata)Serialization.jsonMapper().convertValue(objectAsMap, GenericKubernetesResource.class)));
    }

    public Map<String, Object> updateStatus(InputStream objectAsInputStream) throws IOException {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.updateStatus((HasMetadata)Serialization.unmarshal(objectAsInputStream, GenericKubernetesResource.class)));
    }

    @Override
    public Map<String, Object> get() {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.get());
    }

    @Deprecated
    public Map<String, Object> get(String name) {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)this.delegate.withName(name).get());
    }

    @Deprecated
    public Map<String, Object> get(String namespace, String name) {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResource)((Resource)this.delegate.inNamespace(namespace).withName(name)).get());
    }

    @Override
    public Map<String, Object> list() {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResourceList)this.delegate.list());
    }

    @Override
    public Map<String, Object> list(Integer limitVal, String continueVal) {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResourceList)this.delegate.list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(limitVal.longValue())).withContinue(continueVal)).build()));
    }

    @Override
    public Map<String, Object> list(ListOptions listOptions) {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResourceList)this.delegate.list(listOptions));
    }

    public Map<String, Object> list(String namespace) {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResourceList)this.delegate.inNamespace(namespace).list());
    }

    public Map<String, Object> list(String namespace, Map<String, String> labels) {
        return RawCustomResourceOperationsImpl.toMap((GenericKubernetesResourceList)this.delegate.inNamespace(namespace).list(((ListOptionsBuilder)new ListOptionsBuilder().withLabelSelector(this.getLabelsQueryParam(labels))).build()));
    }

    @Deprecated
    public boolean delete(String namespaceOrName) {
        if (this.delegate.isResourceNamespaced()) {
            return this.delegate.inNamespace(namespaceOrName).delete();
        }
        return this.delegate.withName(namespaceOrName).delete();
    }

    public boolean delete(String namespaceOrName, boolean cascading) throws IOException {
        if (this.delegate.isResourceNamespaced()) {
            return this.delegate.inNamespace(namespaceOrName).delete();
        }
        return ((EditReplacePatchDeletable)this.delegate.withName(namespaceOrName).cascading(cascading)).delete();
    }

    public boolean delete(String namespaceOrName, DeleteOptions deleteOptions) throws IOException {
        if (this.delegate.isResourceNamespaced()) {
            return this.withDeleteOptions(deleteOptions).inNamespace(namespaceOrName).delete();
        }
        return this.withDeleteOptions(deleteOptions).withName(namespaceOrName).delete();
    }

    @Deprecated
    public boolean delete(String namespace, String name) throws IOException {
        return ((Resource)this.delegate.inNamespace(namespace).withName(name)).delete();
    }

    public boolean delete(String namespace, String name, boolean cascading) throws IOException {
        return ((EditReplacePatchDeletable)((Resource)this.delegate.inNamespace(namespace).withName(name)).cascading(cascading)).delete();
    }

    public boolean delete(String namespace, String name, String propagationPolicy) throws IOException {
        return ((EditReplacePatchDeletable)((Resource)this.delegate.inNamespace(namespace).withName(name)).withPropagationPolicy(RawCustomResourceOperationsImpl.resolveDeletionPropagation(propagationPolicy))).delete();
    }

    public boolean delete(String namespace, String name, DeleteOptions deleteOptions) throws IOException {
        return this.withDeleteOptions(deleteOptions).inNamespace(namespace).withName(name).delete();
    }

    @Override
    public Boolean delete() {
        return this.delegate.delete();
    }

    public Watch watch(Watcher<String> watcher) throws IOException {
        return this.delegate.watch(new DelegateWatcher(watcher));
    }

    public Watch watch(String namespace, String name, Map<String, String> labels, ListOptions options, Watcher<String> watcher) throws IOException {
        GenericKubernetesResourceOperationsImpl ops = this.delegate;
        if (Utils.isNotNullOrEmpty(namespace)) {
            ops = (GenericKubernetesResourceOperationsImpl)ops.inNamespace(namespace);
        }
        if (Utils.isNotNullOrEmpty(name)) {
            ops = (GenericKubernetesResourceOperationsImpl)ops.withName(name);
        }
        return ops.watch(((ListOptionsBuilder)RawCustomResourceOperationsImpl.listOptionsBuilder(options).withLabelSelector(this.getLabelsQueryParam(labels))).build(), new DelegateWatcher(watcher));
    }

    public Watch watch(String namespace, String name, Map<String, String> labels, String resourceVersion, Watcher<String> watcher) throws IOException {
        return this.watch(namespace, name, labels, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    public Watch watch(String namespace, Watcher<String> watcher) throws IOException {
        return this.watch(namespace, null, null, (ListOptions)null, watcher);
    }

    public Watch watch(String namespace, String resourceVersion, Watcher<String> watcher) throws IOException {
        return this.watch(namespace, null, null, resourceVersion, watcher);
    }

    public Watch watch(String namespace, ListOptions options, Watcher<String> watcher) throws IOException {
        return this.watch(namespace, null, null, options, watcher);
    }

    public Watch watch(Map<String, String> labels, ListOptions options, Watcher<String> watcher) throws IOException {
        return this.delegate.watch(((ListOptionsBuilder)RawCustomResourceOperationsImpl.listOptionsBuilder(options).withLabelSelector(this.getLabelsQueryParam(labels))).build(), new DelegateWatcher(watcher));
    }

    private String getLabelsQueryParam(Map<String, String> labels) {
        if (labels == null) {
            return null;
        }
        StringBuilder labelQueryBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (labelQueryBuilder.length() > 0) {
                labelQueryBuilder.append(",");
            }
            labelQueryBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return labelQueryBuilder.toString();
    }

    private static DeletionPropagation resolveDeletionPropagation(String propagationPolicy) {
        return Stream.of(DeletionPropagation.values()).filter(dp -> dp.name().toUpperCase(Locale.ENGLISH).equals(propagationPolicy.toUpperCase(Locale.ENGLISH))).findFirst().orElse(HasMetadataOperation.DEFAULT_PROPAGATION_POLICY);
    }

    private long resolveGracePeriod(Long gracePeriodInSeconds) {
        return gracePeriodInSeconds != null ? gracePeriodInSeconds : this.delegate.getGracePeriodSeconds();
    }

    private DeletionPropagation resolvePropagationPolicy(String deletionPropagation) {
        return deletionPropagation != null ? RawCustomResourceOperationsImpl.resolveDeletionPropagation(deletionPropagation) : this.delegate.getPropagationPolicy();
    }

    private static ListOptionsBuilder listOptionsBuilder(ListOptions options) {
        return options == null ? new ListOptionsBuilder() : new ListOptionsBuilder(options);
    }

    private static Map<String, Object> toMap(GenericKubernetesResource gkr) {
        return Serialization.jsonMapper().convertValue((Object)gkr, new TypeReference<Map<String, Object>>(){});
    }

    private static Map<String, Object> toMap(GenericKubernetesResourceList gkrl) {
        return Serialization.jsonMapper().convertValue((Object)gkrl, new TypeReference<Map<String, Object>>(){});
    }

    private static final class DelegateWatcher
    implements Watcher<GenericKubernetesResource> {
        private final Watcher<String> delegate;

        public DelegateWatcher(Watcher<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean reconnecting() {
            return this.delegate.reconnecting();
        }

        @Override
        public void eventReceived(Watcher.Action action, GenericKubernetesResource resource) {
            try {
                this.delegate.eventReceived(action, Serialization.jsonMapper().writeValueAsString(resource));
            }
            catch (JsonProcessingException e) {
                this.delegate.eventReceived(action, resource.toString());
            }
        }

        @Override
        public void onClose() {
            this.delegate.onClose();
        }

        @Override
        public void onClose(WatcherException cause) {
            this.delegate.onClose(cause);
        }
    }
}

