/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import java.io.File;

final class InstallYarnExecutorConfig
implements YarnExecutorConfig {
    private static final String YARN_WINDOWS = "/node/yarn".concat("/dist/bin/yarn.cmd").replaceAll("/", "\\\\");
    private static final String YARN_DEFAULT = "/node/yarn/dist/bin/yarn";
    private File nodePath;
    private final InstallConfig installConfig;

    public InstallYarnExecutorConfig(InstallConfig installConfig) {
        this.installConfig = installConfig;
        this.nodePath = new InstallNodeExecutorConfig(installConfig).getNodePath();
    }

    @Override
    public File getNodePath() {
        return this.nodePath;
    }

    @Override
    public File getYarnPath() {
        String yarnExecutable = this.getPlatform().isWindows() ? YARN_WINDOWS : YARN_DEFAULT;
        return new File(this.installConfig.getInstallDirectory() + yarnExecutable);
    }

    @Override
    public File getWorkingDirectory() {
        return this.installConfig.getWorkingDirectory();
    }

    @Override
    public Platform getPlatform() {
        return this.installConfig.getPlatform();
    }
}

