/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

class ChunkedAssociativeLongArray {
    private static final long[] EMPTY = new long[0];
    private static final int DEFAULT_CHUNK_SIZE = 512;
    private static final int MAX_CACHE_SIZE = 128;
    private final int defaultChunkSize;
    private final ArrayDeque<SoftReference<Chunk>> chunksCache = new ArrayDeque();
    private final LinkedList<Chunk> chunks = new LinkedList();

    ChunkedAssociativeLongArray() {
        this(512);
    }

    ChunkedAssociativeLongArray(int chunkSize) {
        this.defaultChunkSize = chunkSize;
    }

    private Chunk allocateChunk() {
        SoftReference<Chunk> chunkRef;
        Chunk chunk2;
        do {
            if ((chunkRef = this.chunksCache.pollLast()) != null) continue;
            return new Chunk(this.defaultChunkSize);
        } while ((chunk2 = chunkRef.get()) == null);
        chunk2.cursor = 0;
        chunk2.startIndex = 0;
        chunk2.chunkSize = chunk2.keys.length;
        return chunk2;
    }

    private void freeChunk(Chunk chunk2) {
        if (this.chunksCache.size() < 128) {
            this.chunksCache.add(new SoftReference<Chunk>(chunk2));
        }
    }

    synchronized boolean put(long key2, long value2) {
        Chunk activeChunk = this.chunks.peekLast();
        if (activeChunk == null) {
            activeChunk = this.allocateChunk();
            this.chunks.add(activeChunk);
        } else {
            boolean isFull;
            if (activeChunk.cursor != 0 && activeChunk.keys[activeChunk.cursor - 1] > key2) {
                return false;
            }
            boolean bl = isFull = activeChunk.cursor - activeChunk.startIndex == activeChunk.chunkSize;
            if (isFull) {
                activeChunk = this.allocateChunk();
                this.chunks.add(activeChunk);
            }
        }
        activeChunk.append(key2, value2);
        return true;
    }

    synchronized long[] values() {
        int valuesSize = this.size();
        if (valuesSize == 0) {
            return EMPTY;
        }
        long[] values = new long[valuesSize];
        int valuesIndex = 0;
        for (Chunk copySourceChunk : this.chunks) {
            int length2 = copySourceChunk.cursor - copySourceChunk.startIndex;
            int itemsToCopy = Math.min(valuesSize - valuesIndex, length2);
            System.arraycopy(copySourceChunk.values, copySourceChunk.startIndex, values, valuesIndex, itemsToCopy);
            valuesIndex += length2;
        }
        return values;
    }

    synchronized int size() {
        int result2 = 0;
        for (Chunk chunk2 : this.chunks) {
            result2 += chunk2.cursor - chunk2.startIndex;
        }
        return result2;
    }

    synchronized String out() {
        Iterator fromTailIterator = this.chunks.iterator();
        StringBuilder builder = new StringBuilder();
        while (fromTailIterator.hasNext()) {
            Chunk copySourceChunk = (Chunk)fromTailIterator.next();
            builder.append('[');
            for (int i2 = copySourceChunk.startIndex; i2 < copySourceChunk.cursor; ++i2) {
                long key2 = copySourceChunk.keys[i2];
                long value2 = copySourceChunk.values[i2];
                builder.append('(').append(key2).append(": ").append(value2).append(')').append(' ');
            }
            builder.append(']');
            if (!fromTailIterator.hasNext()) continue;
            builder.append("->");
        }
        return builder.toString();
    }

    synchronized void trim(long startKey, long endKey) {
        ListIterator<Chunk> fromHeadIterator = this.chunks.listIterator(this.chunks.size());
        while (fromHeadIterator.hasPrevious()) {
            Chunk currentHead = fromHeadIterator.previous();
            if (this.isFirstElementIsEmptyOrGreaterEqualThanKey(currentHead, endKey)) {
                this.freeChunk(currentHead);
                fromHeadIterator.remove();
                continue;
            }
            int newEndIndex = this.findFirstIndexOfGreaterEqualElements(currentHead.keys, currentHead.startIndex, currentHead.cursor, endKey);
            currentHead.cursor = newEndIndex;
            break;
        }
        ListIterator fromTailIterator = this.chunks.listIterator();
        while (fromTailIterator.hasNext()) {
            Chunk currentTail = (Chunk)fromTailIterator.next();
            if (this.isLastElementIsLessThanKey(currentTail, startKey)) {
                this.freeChunk(currentTail);
                fromTailIterator.remove();
                continue;
            }
            int newStartIndex = this.findFirstIndexOfGreaterEqualElements(currentTail.keys, currentTail.startIndex, currentTail.cursor, startKey);
            if (currentTail.startIndex == newStartIndex) break;
            currentTail.startIndex = newStartIndex;
            currentTail.chunkSize = currentTail.cursor - currentTail.startIndex;
            break;
        }
    }

    synchronized void clear(long startKey, long endKey) {
        ListIterator<Chunk> fromHeadIterator = this.chunks.listIterator(this.chunks.size());
        while (fromHeadIterator.hasPrevious()) {
            Chunk afterTailChunk;
            Chunk currentTail = fromHeadIterator.previous();
            if (this.isFirstElementIsEmptyOrGreaterEqualThanKey(currentTail, endKey) || (afterTailChunk = this.splitChunkOnTwoSeparateChunks(currentTail, endKey)) == null) continue;
            fromHeadIterator.add(afterTailChunk);
            break;
        }
        while (fromHeadIterator.hasPrevious()) {
            Chunk afterGapHead = fromHeadIterator.previous();
            if (this.isFirstElementIsEmptyOrGreaterEqualThanKey(afterGapHead, startKey)) {
                this.freeChunk(afterGapHead);
                fromHeadIterator.remove();
                continue;
            }
            int newEndIndex = this.findFirstIndexOfGreaterEqualElements(afterGapHead.keys, afterGapHead.startIndex, afterGapHead.cursor, startKey);
            if (newEndIndex == afterGapHead.startIndex) break;
            if (afterGapHead.cursor == newEndIndex) continue;
            afterGapHead.cursor = newEndIndex;
            afterGapHead.chunkSize = afterGapHead.cursor - afterGapHead.startIndex;
            break;
        }
    }

    synchronized void clear() {
        this.chunks.clear();
    }

    private Chunk splitChunkOnTwoSeparateChunks(Chunk chunk2, long key2) {
        int splitIndex = this.findFirstIndexOfGreaterEqualElements(chunk2.keys, chunk2.startIndex, chunk2.cursor, key2);
        if (splitIndex == chunk2.startIndex || splitIndex == chunk2.cursor) {
            return null;
        }
        int newTailSize = splitIndex - chunk2.startIndex;
        Chunk newTail = new Chunk(chunk2.keys, chunk2.values, chunk2.startIndex, splitIndex, newTailSize);
        chunk2.startIndex = splitIndex;
        chunk2.chunkSize = chunk2.chunkSize - newTailSize;
        return newTail;
    }

    private boolean isFirstElementIsEmptyOrGreaterEqualThanKey(Chunk chunk2, long key2) {
        return chunk2.cursor == chunk2.startIndex || chunk2.keys[chunk2.startIndex] >= key2;
    }

    private boolean isLastElementIsLessThanKey(Chunk chunk2, long key2) {
        return chunk2.cursor == chunk2.startIndex || chunk2.keys[chunk2.cursor - 1] < key2;
    }

    private int findFirstIndexOfGreaterEqualElements(long[] array, int startIndex, int endIndex, long minKey) {
        if (endIndex == startIndex || array[startIndex] >= minKey) {
            return startIndex;
        }
        int searchIndex = Arrays.binarySearch(array, startIndex, endIndex, minKey);
        int realIndex = searchIndex < 0 ? -(searchIndex + 1) : searchIndex;
        return realIndex;
    }

    private static class Chunk {
        private final long[] keys;
        private final long[] values;
        private int chunkSize;
        private int startIndex = 0;
        private int cursor = 0;

        private Chunk(int chunkSize) {
            this.chunkSize = chunkSize;
            this.keys = new long[chunkSize];
            this.values = new long[chunkSize];
        }

        private Chunk(long[] keys2, long[] values, int startIndex, int cursor, int chunkSize) {
            this.keys = keys2;
            this.values = values;
            this.startIndex = startIndex;
            this.cursor = cursor;
            this.chunkSize = chunkSize;
        }

        private void append(long key2, long value2) {
            this.keys[this.cursor] = key2;
            this.values[this.cursor] = value2;
            ++this.cursor;
        }
    }
}

