/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt.proc;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ClockSkewAware;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.proc.JWTClaimsVerifier;
import com.nimbusds.jwt.util.DateUtils;
import java.util.Date;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWTClaimsVerifier<C extends SecurityContext>
implements JWTClaimsSetVerifier<C>,
JWTClaimsVerifier,
ClockSkewAware {
    public static final int DEFAULT_MAX_CLOCK_SKEW_SECONDS = 60;
    private static final BadJWTException EXPIRED_JWT_EXCEPTION = new BadJWTException("Expired JWT");
    private static final BadJWTException JWT_BEFORE_USE_EXCEPTION = new BadJWTException("JWT before use time");
    private int maxClockSkew = 60;

    @Override
    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @Override
    public void setMaxClockSkew(int maxClockSkewSeconds) {
        this.maxClockSkew = maxClockSkewSeconds;
    }

    @Override
    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        this.verify(claimsSet, null);
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, C context) throws BadJWTException {
        Date now = new Date();
        Date exp2 = claimsSet.getExpirationTime();
        if (exp2 != null && !DateUtils.isAfter(exp2, now, this.maxClockSkew)) {
            throw EXPIRED_JWT_EXCEPTION;
        }
        Date nbf = claimsSet.getNotBeforeTime();
        if (nbf != null && !DateUtils.isBefore(nbf, now, this.maxClockSkew)) {
            throw JWT_BEFORE_USE_EXCEPTION;
        }
    }
}

