/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.Collection;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T arg2, String text) {
        if (arg2 == null) {
            throw new NullPointerException(text);
        }
        return arg2;
    }

    public static int checkPositive(int i2, String name2) {
        if (i2 <= 0) {
            throw new IllegalArgumentException(name2 + ": " + i2 + " (expected: > 0)");
        }
        return i2;
    }

    public static long checkPositive(long i2, String name2) {
        if (i2 <= 0L) {
            throw new IllegalArgumentException(name2 + ": " + i2 + " (expected: > 0)");
        }
        return i2;
    }

    public static int checkPositiveOrZero(int i2, String name2) {
        if (i2 < 0) {
            throw new IllegalArgumentException(name2 + ": " + i2 + " (expected: >= 0)");
        }
        return i2;
    }

    public static long checkPositiveOrZero(long i2, String name2) {
        if (i2 < 0L) {
            throw new IllegalArgumentException(name2 + ": " + i2 + " (expected: >= 0)");
        }
        return i2;
    }

    public static <T> T[] checkNonEmpty(T[] array, String name2) {
        ObjectUtil.checkNotNull(array, name2);
        ObjectUtil.checkPositive(array.length, name2 + ".length");
        return array;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name2) {
        ObjectUtil.checkNotNull(collection, name2);
        ObjectUtil.checkPositive(collection.size(), name2 + ".size");
        return collection;
    }

    public static int intValue(Integer wrapper, int defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }

    public static long longValue(Long wrapper, long defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }
}

