/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.environment.DefaultProcessingEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentUtils {
    private static final DefaultProcessingEnvironment PROCESSING_ENVIRONMENT_IMPLEMENTATION = new DefaultProcessingEnvironment();

    private EnvironmentUtils() {
    }

    public static String[] toStrings(Map<String, String> environment) {
        if (environment == null) {
            return null;
        }
        String[] result2 = new String[environment.size()];
        int i2 = 0;
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            String key2 = entry.getKey() == null ? "" : entry.getKey().toString();
            String value2 = entry.getValue() == null ? "" : entry.getValue().toString();
            result2[i2] = key2 + "=" + value2;
            ++i2;
        }
        return result2;
    }

    public static Map<String, String> getProcEnvironment() throws IOException {
        return PROCESSING_ENVIRONMENT_IMPLEMENTATION.getProcEnvironment();
    }

    public static void addVariableToEnvironment(Map<String, String> environment, String keyAndValue) {
        String[] parsedVariable = EnvironmentUtils.parseEnvironmentVariable(keyAndValue);
        environment.put(parsedVariable[0], parsedVariable[1]);
    }

    private static String[] parseEnvironmentVariable(String keyAndValue) {
        int index2 = keyAndValue.indexOf(61);
        if (index2 == -1) {
            throw new IllegalArgumentException("Environment variable for this platform must contain an equals sign ('=')");
        }
        String[] result2 = new String[]{keyAndValue.substring(0, index2), keyAndValue.substring(index2 + 1)};
        return result2;
    }
}

