/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.build.AbstractStreamBuilder;

public class UnsynchronizedByteArrayInputStream
extends InputStream {
    public static final int END_OF_STREAM = -1;
    private final byte[] data;
    private final int eod;
    private int offset;
    private int markedOffset;

    public static Builder builder() {
        return new Builder();
    }

    private static int minPosLen(byte[] data, int defaultValue) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(defaultValue, "defaultValue");
        return Math.min(defaultValue, data.length > 0 ? data.length : defaultValue);
    }

    private static int requireNonNegative(int value2, String name2) {
        if (value2 < 0) {
            throw new IllegalArgumentException(name2 + " cannot be negative");
        }
        return value2;
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] data) {
        this(data, data.length, 0, 0);
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] data, int offset2) {
        this(data, data.length, Math.min(UnsynchronizedByteArrayInputStream.requireNonNegative(offset2, "offset"), UnsynchronizedByteArrayInputStream.minPosLen(data, offset2)), UnsynchronizedByteArrayInputStream.minPosLen(data, offset2));
    }

    @Deprecated
    public UnsynchronizedByteArrayInputStream(byte[] data, int offset2, int length2) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(offset2, "offset");
        UnsynchronizedByteArrayInputStream.requireNonNegative(length2, "length");
        this.data = Objects.requireNonNull(data, "data");
        this.eod = Math.min(UnsynchronizedByteArrayInputStream.minPosLen(data, offset2) + length2, data.length);
        this.offset = UnsynchronizedByteArrayInputStream.minPosLen(data, offset2);
        this.markedOffset = UnsynchronizedByteArrayInputStream.minPosLen(data, offset2);
    }

    private UnsynchronizedByteArrayInputStream(byte[] data, int eod, int offset2, int markedOffset) {
        this.data = Objects.requireNonNull(data, "data");
        this.eod = eod;
        this.offset = offset2;
        this.markedOffset = markedOffset;
    }

    @Override
    public int available() {
        return this.offset < this.eod ? this.eod - this.offset : 0;
    }

    @Override
    public void mark(int readLimit) {
        this.markedOffset = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        return this.offset < this.eod ? this.data[this.offset++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] dest) {
        Objects.requireNonNull(dest, "dest");
        return this.read(dest, 0, dest.length);
    }

    @Override
    public int read(byte[] dest, int off, int len) {
        Objects.requireNonNull(dest, "dest");
        if (off < 0 || len < 0 || off + len > dest.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.offset >= this.eod) {
            return -1;
        }
        int actualLen = this.eod - this.offset;
        if (len < actualLen) {
            actualLen = len;
        }
        if (actualLen <= 0) {
            return 0;
        }
        System.arraycopy(this.data, this.offset, dest, off, actualLen);
        this.offset += actualLen;
        return actualLen;
    }

    @Override
    public void reset() {
        this.offset = this.markedOffset;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Skipping backward is not supported");
        }
        long actualSkip = this.eod - this.offset;
        if (n < actualSkip) {
            actualSkip = n;
        }
        this.offset = Math.addExact(this.offset, Math.toIntExact(n));
        return actualSkip;
    }

    public static class Builder
    extends AbstractStreamBuilder<UnsynchronizedByteArrayInputStream, Builder> {
        private int offset;
        private int length;

        @Override
        public UnsynchronizedByteArrayInputStream get() throws IOException {
            return new UnsynchronizedByteArrayInputStream(this.checkOrigin().getByteArray(), this.offset, this.length);
        }

        @Override
        public Builder setByteArray(byte[] origin) {
            this.length = Objects.requireNonNull(origin, "origin").length;
            return (Builder)super.setByteArray(origin);
        }

        public Builder setLength(int length2) {
            if (length2 < 0) {
                throw new IllegalArgumentException("length cannot be negative");
            }
            this.length = length2;
            return this;
        }

        public Builder setOffset(int offset2) {
            if (offset2 < 0) {
                throw new IllegalArgumentException("offset cannot be negative");
            }
            this.offset = offset2;
            return this;
        }
    }
}

