/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.output.ProxyWriter;

public class FileWriterWithEncoding
extends ProxyWriter {
    public static Builder builder() {
        return new Builder();
    }

    private static OutputStreamWriter initWriter(File file2, Object encoding2, boolean append2) throws IOException {
        Objects.requireNonNull(file2, "file");
        OutputStream outputStream = null;
        boolean fileExistedAlready = file2.exists();
        try {
            outputStream = FileUtils.newOutputStream(file2, append2);
            if (encoding2 == null || encoding2 instanceof Charset) {
                return new OutputStreamWriter(outputStream, Charsets.toCharset((Charset)encoding2));
            }
            if (encoding2 instanceof CharsetEncoder) {
                return new OutputStreamWriter(outputStream, (CharsetEncoder)encoding2);
            }
            return new OutputStreamWriter(outputStream, (String)encoding2);
        }
        catch (IOException | RuntimeException ex) {
            try {
                IOUtils.close((Closeable)outputStream);
            }
            catch (IOException e) {
                ex.addSuppressed(e);
            }
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, Charset charset) throws IOException {
        this(file2, charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, Charset encoding2, boolean append2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file2, encoding2, append2));
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder) throws IOException {
        this(file2, charsetEncoder, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder, boolean append2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file2, charsetEncoder, append2));
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, String charsetName) throws IOException {
        this(file2, charsetName, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file2, String charsetName, boolean append2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file2, charsetName, append2));
    }

    private FileWriterWithEncoding(OutputStreamWriter outputStreamWriter) {
        super(outputStreamWriter);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, Charset charset) throws IOException {
        this(new File(fileName), charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, Charset charset, boolean append2) throws IOException {
        this(new File(fileName), charset, append2);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, CharsetEncoder encoding2) throws IOException {
        this(new File(fileName), encoding2, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, CharsetEncoder charsetEncoder, boolean append2) throws IOException {
        this(new File(fileName), charsetEncoder, append2);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, String charsetName) throws IOException {
        this(new File(fileName), charsetName, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, String charsetName, boolean append2) throws IOException {
        this(new File(fileName), charsetName, append2);
    }

    public static class Builder
    extends AbstractStreamBuilder<FileWriterWithEncoding, Builder> {
        private boolean append;
        private CharsetEncoder charsetEncoder = super.getCharset().newEncoder();

        @Override
        public FileWriterWithEncoding get() throws IOException {
            if (this.charsetEncoder != null && this.getCharset() != null && !this.charsetEncoder.charset().equals(this.getCharset())) {
                throw new IllegalStateException(String.format("Mismatched Charset(%s) and CharsetEncoder(%s)", this.getCharset(), this.charsetEncoder.charset()));
            }
            Object encoder = this.charsetEncoder != null ? this.charsetEncoder : this.getCharset();
            return new FileWriterWithEncoding(FileWriterWithEncoding.initWriter(this.checkOrigin().getFile(), encoder, this.append));
        }

        public Builder setAppend(boolean append2) {
            this.append = append2;
            return this;
        }

        public Builder setCharsetEncoder(CharsetEncoder charsetEncoder) {
            this.charsetEncoder = charsetEncoder;
            return this;
        }
    }
}

