/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;

public class FieldUtils {
    public static Field[] getAllFields(Class<?> cls) {
        return FieldUtils.getAllFieldsList(cls).toArray(ArrayUtils.EMPTY_FIELD_ARRAY);
    }

    public static List<Field> getAllFieldsList(Class<?> cls) {
        Objects.requireNonNull(cls, "cls");
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) {
        return FieldUtils.getDeclaredField(cls, fieldName, false);
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName, boolean forceAccess) {
        Objects.requireNonNull(cls, "cls");
        Validate.isTrue(StringUtils.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        try {
            Field field2 = cls.getDeclaredField(fieldName);
            if (!MemberUtils.isAccessible(field2)) {
                if (!forceAccess) {
                    return null;
                }
                field2.setAccessible(true);
            }
            return field2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getField(Class<?> cls, String fieldName) {
        return MemberUtils.setAccessibleWorkaround(FieldUtils.getField(cls, fieldName, false));
    }

    public static Field getField(Class<?> cls, String fieldName, boolean forceAccess) {
        Objects.requireNonNull(cls, "cls");
        Validate.isTrue(StringUtils.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field2 = acls.getDeclaredField(fieldName);
                if (!MemberUtils.isPublic(field2)) {
                    if (!forceAccess) continue;
                    field2.setAccessible(true);
                }
                return field2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match2 = null;
        for (Class<?> class1 : ClassUtils.getAllInterfaces(cls)) {
            try {
                Field test2 = class1.getField(fieldName);
                Validate.isTrue(match2 == null, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", fieldName, cls);
                match2 = test2;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match2;
    }

    public static List<Field> getFieldsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        Objects.requireNonNull(annotationCls, "annotationCls");
        return FieldUtils.getAllFieldsList(cls).stream().filter(field2 -> field2.getAnnotation(annotationCls) != null).collect(Collectors.toList());
    }

    public static Field[] getFieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        return FieldUtils.getFieldsListWithAnnotation(cls, annotationCls).toArray(ArrayUtils.EMPTY_FIELD_ARRAY);
    }

    public static Object readDeclaredField(Object target, String fieldName) throws IllegalAccessException {
        return FieldUtils.readDeclaredField(target, fieldName, false);
    }

    public static Object readDeclaredField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(target, "target");
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls, fieldName);
        return FieldUtils.readField(field2, target, false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(cls, fieldName, false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.notNull(field2, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readField(Field field2, Object target) throws IllegalAccessException {
        return FieldUtils.readField(field2, target, false);
    }

    public static Object readField(Field field2, Object target, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(field2, "field");
        if (forceAccess && !field2.isAccessible()) {
            field2.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field2);
        }
        return field2.get(target);
    }

    public static Object readField(Object target, String fieldName) throws IllegalAccessException {
        return FieldUtils.readField(target, fieldName, false);
    }

    public static Object readField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(target, "target");
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate field %s on %s", fieldName, cls);
        return FieldUtils.readField(field2, target, false);
    }

    public static Object readStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        return FieldUtils.readStaticField(cls, fieldName, false);
    }

    public static Object readStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.notNull(field2, "Cannot locate field '%s' on %s", fieldName, cls);
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readStaticField(Field field2) throws IllegalAccessException {
        return FieldUtils.readStaticField(field2, false);
    }

    public static Object readStaticField(Field field2, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(field2, "field");
        Validate.isTrue(MemberUtils.isStatic(field2), "The field '%s' is not static", field2.getName());
        return FieldUtils.readField(field2, null, forceAccess);
    }

    public static void removeFinalModifier(Field field2) {
        FieldUtils.removeFinalModifier(field2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void removeFinalModifier(Field field2, boolean forceAccess) {
        block7: {
            Objects.requireNonNull(field2, "field");
            try {
                boolean doForceAccess;
                if (!Modifier.isFinal(field2.getModifiers())) break block7;
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                boolean bl = doForceAccess = forceAccess && !modifiersField.isAccessible();
                if (doForceAccess) {
                    modifiersField.setAccessible(true);
                }
                try {
                    modifiersField.setInt(field2, field2.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (doForceAccess) {
                        modifiersField.setAccessible(false);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                if (!SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_12)) break block7;
                throw new UnsupportedOperationException("In java 12+ final cannot be removed.", e);
            }
        }
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value2) throws IllegalAccessException {
        FieldUtils.writeDeclaredField(target, fieldName, value2, false);
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value2, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(target, "target");
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        FieldUtils.writeField(field2, target, value2, false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value2) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(cls, fieldName, value2, false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.notNull(field2, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        FieldUtils.writeField(field2, null, value2, false);
    }

    public static void writeField(Field field2, Object target, Object value2) throws IllegalAccessException {
        FieldUtils.writeField(field2, target, value2, false);
    }

    public static void writeField(Field field2, Object target, Object value2, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(field2, "field");
        if (forceAccess && !field2.isAccessible()) {
            field2.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field2);
        }
        field2.set(target, value2);
    }

    public static void writeField(Object target, String fieldName, Object value2) throws IllegalAccessException {
        FieldUtils.writeField(target, fieldName, value2, false);
    }

    public static void writeField(Object target, String fieldName, Object value2, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(target, "target");
        Class<?> cls = target.getClass();
        Field field2 = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.isTrue(field2 != null, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        FieldUtils.writeField(field2, target, value2, false);
    }

    public static void writeStaticField(Class<?> cls, String fieldName, Object value2) throws IllegalAccessException {
        FieldUtils.writeStaticField(cls, fieldName, value2, false);
    }

    public static void writeStaticField(Class<?> cls, String fieldName, Object value2, boolean forceAccess) throws IllegalAccessException {
        Field field2 = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.notNull(field2, "Cannot locate field %s on %s", fieldName, cls);
        FieldUtils.writeStaticField(field2, value2, false);
    }

    public static void writeStaticField(Field field2, Object value2) throws IllegalAccessException {
        FieldUtils.writeStaticField(field2, value2, false);
    }

    public static void writeStaticField(Field field2, Object value2, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(field2, "field");
        Validate.isTrue(MemberUtils.isStatic(field2), "The field %s.%s is not static", field2.getDeclaringClass().getName(), field2.getName());
        FieldUtils.writeField(field2, null, value2, forceAccess);
    }
}

