/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class MethodUtils {
    private static final Comparator<Method> METHOD_BY_SIGNATURE = Comparator.comparing(Method::toString);

    private static int distance(Class<?>[] fromClassArray, Class<?>[] toClassArray) {
        int answer = 0;
        if (!ClassUtils.isAssignable(fromClassArray, toClassArray, true)) {
            return -1;
        }
        for (int offset2 = 0; offset2 < fromClassArray.length; ++offset2) {
            Class<?> aClass = fromClassArray[offset2];
            Class<?> toClass = toClassArray[offset2];
            if (aClass == null || aClass.equals(toClass)) continue;
            if (ClassUtils.isAssignable(aClass, toClass, true) && !ClassUtils.isAssignable(aClass, toClass, false)) {
                ++answer;
                continue;
            }
            answer += 2;
        }
        return answer;
    }

    public static Method getAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method2) {
        Class<?>[] parameterTypes;
        if (!MemberUtils.isAccessible(method2)) {
            return null;
        }
        Class<?> cls = method2.getDeclaringClass();
        if (ClassUtils.isPublic(cls)) {
            return method2;
        }
        String methodName = method2.getName();
        if ((method2 = MethodUtils.getAccessibleMethodFromInterfaceNest(cls, methodName, parameterTypes = method2.getParameterTypes())) == null) {
            method2 = MethodUtils.getAccessibleMethodFromSuperclass(cls, methodName, parameterTypes);
        }
        return method2;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        while (cls != null) {
            Class<?>[] interfaces2;
            for (Class<?> anInterface : interfaces2 = cls.getInterfaces()) {
                if (!ClassUtils.isPublic(anInterface)) continue;
                try {
                    return anInterface.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method2 = MethodUtils.getAccessibleMethodFromInterfaceNest(anInterface, methodName, parameterTypes);
                    if (method2 == null) continue;
                    return method2;
                }
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> parentClass = cls.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            if (!ClassUtils.isPublic(parentClass)) continue;
            try {
                return parentClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList allSuperClassesAndInterfaces = new ArrayList();
        List<Class<?>> allSuperclasses = ClassUtils.getAllSuperclasses(cls);
        int superClassIndex = 0;
        List<Class<?>> allInterfaces = ClassUtils.getAllInterfaces(cls);
        int interfaceIndex = 0;
        while (interfaceIndex < allInterfaces.size() || superClassIndex < allSuperclasses.size()) {
            Class<?> acls = interfaceIndex >= allInterfaces.size() ? allSuperclasses.get(superClassIndex++) : (superClassIndex >= allSuperclasses.size() || superClassIndex >= interfaceIndex ? allInterfaces.get(interfaceIndex++) : allSuperclasses.get(superClassIndex++));
            allSuperClassesAndInterfaces.add(acls);
        }
        return allSuperClassesAndInterfaces;
    }

    public static <A extends Annotation> A getAnnotation(Method method2, Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Objects.requireNonNull(method2, "method");
        Objects.requireNonNull(annotationCls, "annotationCls");
        if (!ignoreAccess && !MemberUtils.isAccessible(method2)) {
            return null;
        }
        A annotation2 = method2.getAnnotation(annotationCls);
        if (annotation2 == null && searchSupers) {
            Class<?> mcls = method2.getDeclaringClass();
            List<Class<?>> classes2 = MethodUtils.getAllSuperclassesAndInterfaces(mcls);
            for (Class<?> acls : classes2) {
                Method equivalentMethod = ignoreAccess ? MethodUtils.getMatchingMethod(acls, method2.getName(), method2.getParameterTypes()) : MethodUtils.getMatchingAccessibleMethod(acls, method2.getName(), method2.getParameterTypes());
                if (equivalentMethod == null || (annotation2 = equivalentMethod.getAnnotation(annotationCls)) == null) continue;
                break;
            }
        }
        return annotation2;
    }

    public static Method getMatchingAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            return MemberUtils.setAccessibleWorkaround(cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method[] methods2 = cls.getMethods();
            List matchingMethods = Stream.of(methods2).filter(method2 -> method2.getName().equals(methodName) && MemberUtils.isMatchingMethod(method2, parameterTypes)).collect(Collectors.toList());
            matchingMethods.sort(METHOD_BY_SIGNATURE);
            Method bestMatch = null;
            for (Method method3 : matchingMethods) {
                Method accessibleMethod = MethodUtils.getAccessibleMethod(method3);
                if (accessibleMethod == null || bestMatch != null && MemberUtils.compareMethodFit(accessibleMethod, bestMatch, parameterTypes) >= 0) continue;
                bestMatch = accessibleMethod;
            }
            if (bestMatch != null) {
                MemberUtils.setAccessibleWorkaround(bestMatch);
            }
            if (bestMatch != null && bestMatch.isVarArgs() && bestMatch.getParameterTypes().length > 0 && parameterTypes.length > 0) {
                String parameterTypeSuperClassName;
                Class<?>[] methodParameterTypes = bestMatch.getParameterTypes();
                Class<?> methodParameterComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
                String methodParameterComponentTypeName = ClassUtils.primitiveToWrapper(methodParameterComponentType).getName();
                Class<?> lastParameterType = parameterTypes[parameterTypes.length - 1];
                String parameterTypeName = lastParameterType == null ? null : lastParameterType.getName();
                String string2 = parameterTypeSuperClassName = lastParameterType == null ? null : lastParameterType.getSuperclass().getName();
                if (parameterTypeName != null && parameterTypeSuperClassName != null && !methodParameterComponentTypeName.equals(parameterTypeName) && !methodParameterComponentTypeName.equals(parameterTypeSuperClassName)) {
                    return null;
                }
            }
            return bestMatch;
        }
    }

    public static Method getMatchingMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(cls, "cls");
        Validate.notEmpty(methodName, "methodName", new Object[0]);
        List methods2 = Stream.of(cls.getDeclaredMethods()).filter(method2 -> method2.getName().equals(methodName)).collect(Collectors.toList());
        ClassUtils.getAllSuperclasses(cls).stream().map(Class::getDeclaredMethods).flatMap(Stream::of).filter(method2 -> method2.getName().equals(methodName)).forEach(methods2::add);
        for (Method method3 : methods2) {
            if (!Arrays.deepEquals(method3.getParameterTypes(), parameterTypes)) continue;
            return method3;
        }
        TreeMap candidates = new TreeMap();
        methods2.stream().filter(method2 -> ClassUtils.isAssignable(parameterTypes, method2.getParameterTypes(), true)).forEach(method2 -> {
            int distance = MethodUtils.distance(parameterTypes, method2.getParameterTypes());
            List candidatesAtDistance = candidates.computeIfAbsent(distance, k -> new ArrayList());
            candidatesAtDistance.add(method2);
        });
        if (candidates.isEmpty()) {
            return null;
        }
        List bestCandidates = (List)candidates.values().iterator().next();
        if (bestCandidates.size() == 1 || !Objects.equals(((Method)bestCandidates.get(0)).getDeclaringClass(), ((Method)bestCandidates.get(1)).getDeclaringClass())) {
            return (Method)bestCandidates.get(0);
        }
        throw new IllegalStateException(String.format("Found multiple candidates for method %s on class %s : %s", methodName + Stream.of(parameterTypes).map(String::valueOf).collect(Collectors.joining(",", "(", ")")), cls.getName(), bestCandidates.stream().map(Method::toString).collect(Collectors.joining(",", "[", "]"))));
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        return MethodUtils.getMethodsListWithAnnotation(cls, annotationCls, false, false);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Objects.requireNonNull(cls, "cls");
        Objects.requireNonNull(annotationCls, "annotationCls");
        ArrayList classes2 = searchSupers ? MethodUtils.getAllSuperclassesAndInterfaces(cls) : new ArrayList();
        classes2.add(0, cls);
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        classes2.forEach(acls -> {
            Method[] methods2 = ignoreAccess ? acls.getDeclaredMethods() : acls.getMethods();
            Stream.of(methods2).filter(method2 -> method2.isAnnotationPresent(annotationCls)).forEachOrdered(annotatedMethods::add);
        });
        return annotatedMethods;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        return MethodUtils.getMethodsWithAnnotation(cls, annotationCls, false, false);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        return MethodUtils.getMethodsListWithAnnotation(cls, annotationCls, searchSupers, ignoreAccess).toArray(ArrayUtils.EMPTY_METHOD_ARRAY);
    }

    public static Set<Method> getOverrideHierarchy(Method method2, ClassUtils.Interfaces interfacesBehavior) {
        Objects.requireNonNull(method2, "method");
        LinkedHashSet<Method> result2 = new LinkedHashSet<Method>();
        result2.add(method2);
        Object[] parameterTypes = method2.getParameterTypes();
        Class<?> declaringClass = method2.getDeclaringClass();
        Iterator<Class<?>> hierarchy = ClassUtils.hierarchy(declaringClass, interfacesBehavior).iterator();
        hierarchy.next();
        block0: while (hierarchy.hasNext()) {
            Class<?> c = hierarchy.next();
            Method m = MethodUtils.getMatchingAccessibleMethod(c, method2.getName(), parameterTypes);
            if (m == null) continue;
            if (Arrays.equals(m.getParameterTypes(), parameterTypes)) {
                result2.add(m);
                continue;
            }
            Map<TypeVariable<?>, Type> typeArguments = TypeUtils.getTypeArguments(declaringClass, m.getDeclaringClass());
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                Type parentType;
                Type childType = TypeUtils.unrollVariables(typeArguments, method2.getGenericParameterTypes()[i2]);
                if (!TypeUtils.equals(childType, parentType = TypeUtils.unrollVariables(typeArguments, m.getGenericParameterTypes()[i2]))) continue block0;
            }
            result2.add(m);
        }
        return result2;
    }

    static Object[] getVarArgs(Object[] args2, Class<?>[] methodParameterTypes) {
        if (args2.length == methodParameterTypes.length && (args2[args2.length - 1] == null || args2[args2.length - 1].getClass().equals(methodParameterTypes[methodParameterTypes.length - 1]))) {
            return args2;
        }
        Object[] newArgs = new Object[methodParameterTypes.length];
        System.arraycopy(args2, 0, newArgs, 0, methodParameterTypes.length - 1);
        Class<?> varArgComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
        int varArgLength = args2.length - methodParameterTypes.length + 1;
        Object varArgsArray = Array.newInstance(ClassUtils.primitiveToWrapper(varArgComponentType), varArgLength);
        System.arraycopy(args2, methodParameterTypes.length - 1, varArgsArray, 0, varArgLength);
        if (varArgComponentType.isPrimitive()) {
            varArgsArray = ArrayUtils.toPrimitive(varArgsArray);
        }
        newArgs[methodParameterTypes.length - 1] = varArgsArray;
        return newArgs;
    }

    public static Object invokeExactMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod(object, methodName, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args2 = ArrayUtils.nullToEmpty(args2);
        return MethodUtils.invokeExactMethod(object, methodName, args2, ClassUtils.toClass(args2));
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Objects.requireNonNull(object, "object");
        args2 = ArrayUtils.nullToEmpty(args2);
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        Class<?> cls = object.getClass();
        Method method2 = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes);
        if (method2 == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + cls.getName());
        }
        return method2.invoke(object, args2);
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args2 = ArrayUtils.nullToEmpty(args2);
        return MethodUtils.invokeExactStaticMethod(cls, methodName, args2, ClassUtils.toClass(args2));
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args2 = ArrayUtils.nullToEmpty(args2);
        Method method2 = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method2 == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method2.invoke(null, args2);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, forceAccess, methodName, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args2 = ArrayUtils.nullToEmpty(args2);
        return MethodUtils.invokeMethod(object, forceAccess, methodName, args2, ClassUtils.toClass(args2));
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method2;
        String messagePrefix;
        Objects.requireNonNull(object, "object");
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        args2 = ArrayUtils.nullToEmpty(args2);
        Class<?> cls = object.getClass();
        if (forceAccess) {
            messagePrefix = "No such method: ";
            method2 = MethodUtils.getMatchingMethod(cls, methodName, parameterTypes);
            if (method2 != null && !method2.isAccessible()) {
                method2.setAccessible(true);
            }
        } else {
            messagePrefix = "No such accessible method: ";
            method2 = MethodUtils.getMatchingAccessibleMethod(cls, methodName, parameterTypes);
        }
        if (method2 == null) {
            throw new NoSuchMethodException(messagePrefix + methodName + "() on object: " + cls.getName());
        }
        args2 = MethodUtils.toVarArgs(method2, args2);
        return method2.invoke(object, args2);
    }

    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, methodName, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args2 = ArrayUtils.nullToEmpty(args2);
        return MethodUtils.invokeMethod(object, methodName, args2, ClassUtils.toClass(args2));
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, false, methodName, args2, parameterTypes);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object ... args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args2 = ArrayUtils.nullToEmpty(args2);
        return MethodUtils.invokeStaticMethod(cls, methodName, args2, ClassUtils.toClass(args2));
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args2 = ArrayUtils.nullToEmpty(args2);
        Method method2 = MethodUtils.getMatchingAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method2 == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        args2 = MethodUtils.toVarArgs(method2, args2);
        return method2.invoke(null, args2);
    }

    private static Object[] toVarArgs(Method method2, Object[] args2) {
        if (method2.isVarArgs()) {
            Class<?>[] methodParameterTypes = method2.getParameterTypes();
            args2 = MethodUtils.getVarArgs(args2, methodParameterTypes);
        }
        return args2;
    }
}

