/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ArrayBackedTag
implements Tag {
    private final byte type;
    private final byte[] bytes;
    private int offset = 0;
    private int length = 0;

    public ArrayBackedTag(byte tagType, String tag2) {
        this(tagType, Bytes.toBytes(tag2));
    }

    public ArrayBackedTag(byte tagType, byte[] tag2) {
        int tagLength = tag2.length + 1;
        if (tagLength > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.length = 2 + tagLength;
        this.bytes = new byte[this.length];
        int pos2 = Bytes.putAsShort(this.bytes, 0, tagLength);
        pos2 = Bytes.putByte(this.bytes, pos2, tagType);
        Bytes.putBytes(this.bytes, pos2, tag2, 0, tag2.length);
        this.type = tagType;
    }

    public ArrayBackedTag(byte[] bytes2, int offset2) {
        this(bytes2, offset2, ArrayBackedTag.getLength(bytes2, offset2));
    }

    private static int getLength(byte[] bytes2, int offset2) {
        return 2 + Bytes.readAsInt(bytes2, offset2, 2);
    }

    public ArrayBackedTag(byte[] bytes2, int offset2, int length2) {
        if (length2 > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.bytes = bytes2;
        this.offset = offset2;
        this.length = length2;
        this.type = bytes2[offset2 + 2];
    }

    @Override
    public byte[] getValueArray() {
        return this.bytes;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public int getValueLength() {
        return this.length - 3;
    }

    @Override
    public int getValueOffset() {
        return this.offset + 3;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public ByteBuffer getValueByteBuffer() {
        return ByteBuffer.wrap(this.bytes);
    }

    public String toString() {
        return "[Tag type : " + this.type + ", value : " + Bytes.toStringBinary(this.bytes, this.getValueOffset(), this.getValueLength()) + "]";
    }
}

