/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NoTagsKeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Function;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.IterableUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KeyValueUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueUtil.class);

    public static int length(short rlen, byte flen, int qlen, int vlen, int tlen, boolean withTags) {
        if (withTags) {
            return (int)KeyValue.getKeyValueDataStructureSize(rlen, flen, qlen, vlen, tlen);
        }
        return (int)KeyValue.getKeyValueDataStructureSize(rlen, flen, qlen, vlen);
    }

    public static int keyLength(Cell cell) {
        return KeyValueUtil.keyLength(cell.getRowLength(), cell.getFamilyLength(), cell.getQualifierLength());
    }

    private static int keyLength(short rlen, byte flen, int qlen) {
        return (int)KeyValue.getKeyDataStructureSize(rlen, flen, qlen);
    }

    public static int lengthWithMvccVersion(KeyValue kv, boolean includeMvccVersion) {
        int length2 = kv.getLength();
        if (includeMvccVersion) {
            length2 += WritableUtils.getVIntSize((long)kv.getSequenceId());
        }
        return length2;
    }

    public static int totalLengthWithMvccVersion(Iterable<? extends KeyValue> kvs, boolean includeMvccVersion) {
        int length2 = 0;
        for (KeyValue keyValue : IterableUtils.emptyIfNull(kvs)) {
            length2 += KeyValueUtil.lengthWithMvccVersion(keyValue, includeMvccVersion);
        }
        return length2;
    }

    public static KeyValue copyToNewKeyValue(Cell cell) {
        byte[] bytes2 = KeyValueUtil.copyToNewByteArray(cell);
        KeyValue kvCell = new KeyValue(bytes2, 0, bytes2.length);
        kvCell.setSequenceId(cell.getSequenceId());
        return kvCell;
    }

    public static ByteBuffer copyKeyToNewByteBuffer(Cell cell) {
        byte[] bytes2 = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyTo(cell, bytes2, 0);
        ByteBuffer buffer = ByteBuffer.wrap(bytes2);
        return buffer;
    }

    public static KeyValue toNewKeyCell(Cell cell) {
        byte[] bytes2 = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyTo(cell, bytes2, 0);
        KeyValue.KeyOnlyKeyValue kv = new KeyValue.KeyOnlyKeyValue(bytes2, 0, bytes2.length);
        kv.setSequenceId(cell.getSequenceId());
        return kv;
    }

    public static byte[] copyToNewByteArray(Cell cell) {
        int v1Length = KeyValueUtil.length(cell.getRowLength(), cell.getFamilyLength(), cell.getQualifierLength(), cell.getValueLength(), cell.getTagsLength(), true);
        byte[] backingBytes = new byte[v1Length];
        KeyValueUtil.appendToByteArray(cell, backingBytes, 0, true);
        return backingBytes;
    }

    public static int appendKeyTo(Cell cell, byte[] output, int offset2) {
        int nextOffset = offset2;
        nextOffset = Bytes.putShort(output, nextOffset, cell.getRowLength());
        nextOffset = CellUtil.copyRowTo(cell, output, nextOffset);
        nextOffset = Bytes.putByte(output, nextOffset, cell.getFamilyLength());
        nextOffset = CellUtil.copyFamilyTo(cell, output, nextOffset);
        nextOffset = CellUtil.copyQualifierTo(cell, output, nextOffset);
        nextOffset = Bytes.putLong(output, nextOffset, cell.getTimestamp());
        nextOffset = Bytes.putByte(output, nextOffset, cell.getTypeByte());
        return nextOffset;
    }

    public static int appendToByteArray(Cell cell, byte[] output, int offset2, boolean withTags) {
        int pos2 = offset2;
        pos2 = Bytes.putInt(output, pos2, KeyValueUtil.keyLength(cell));
        pos2 = Bytes.putInt(output, pos2, cell.getValueLength());
        pos2 = KeyValueUtil.appendKeyTo(cell, output, pos2);
        pos2 = CellUtil.copyValueTo(cell, output, pos2);
        if (withTags && cell.getTagsLength() > 0) {
            pos2 = Bytes.putAsShort(output, pos2, cell.getTagsLength());
            pos2 = PrivateCellUtil.copyTagsTo(cell, output, pos2);
        }
        return pos2;
    }

    public static int appendTo(Cell cell, ByteBuffer buf, int offset2, boolean withTags) {
        offset2 = ByteBufferUtils.putInt(buf, offset2, KeyValueUtil.keyLength(cell));
        offset2 = ByteBufferUtils.putInt(buf, offset2, cell.getValueLength());
        offset2 = KeyValueUtil.appendKeyTo(cell, buf, offset2);
        offset2 = CellUtil.copyValueTo(cell, buf, offset2);
        int tagsLength = cell.getTagsLength();
        if (withTags && tagsLength > 0) {
            offset2 = ByteBufferUtils.putAsShort(buf, offset2, tagsLength);
            offset2 = PrivateCellUtil.copyTagsTo(cell, buf, offset2);
        }
        return offset2;
    }

    public static int appendKeyTo(Cell cell, ByteBuffer buf, int offset2) {
        offset2 = ByteBufferUtils.putShort(buf, offset2, cell.getRowLength());
        offset2 = CellUtil.copyRowTo(cell, buf, offset2);
        offset2 = ByteBufferUtils.putByte(buf, offset2, cell.getFamilyLength());
        offset2 = CellUtil.copyFamilyTo(cell, buf, offset2);
        offset2 = CellUtil.copyQualifierTo(cell, buf, offset2);
        offset2 = ByteBufferUtils.putLong(buf, offset2, cell.getTimestamp());
        offset2 = ByteBufferUtils.putByte(buf, offset2, cell.getTypeByte());
        return offset2;
    }

    public static void appendToByteBuffer(ByteBuffer bb, KeyValue kv, boolean includeMvccVersion) {
        bb.limit(bb.position() + kv.getLength());
        bb.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
        if (includeMvccVersion) {
            int numMvccVersionBytes = WritableUtils.getVIntSize((long)kv.getSequenceId());
            ByteBufferUtils.extendLimit(bb, numMvccVersionBytes);
            ByteBufferUtils.writeVLong(bb, kv.getSequenceId());
        }
    }

    public static KeyValue nextShallowCopy(ByteBuffer bb, boolean includesMvccVersion, boolean includesTags) {
        if (bb.isDirect()) {
            throw new IllegalArgumentException("only supports heap buffers");
        }
        if (bb.remaining() < 1) {
            return null;
        }
        KeyValue keyValue = null;
        int underlyingArrayOffset = bb.arrayOffset() + bb.position();
        int keyLength = bb.getInt();
        int valueLength = bb.getInt();
        ByteBufferUtils.skip(bb, keyLength + valueLength);
        int tagsLength = 0;
        if (includesTags) {
            tagsLength = (bb.get() & 0xFF) << 8 ^ bb.get() & 0xFF;
            ByteBufferUtils.skip(bb, tagsLength);
        }
        int kvLength = (int)KeyValue.getKeyValueDataStructureSize(keyLength, valueLength, tagsLength);
        keyValue = new KeyValue(bb.array(), underlyingArrayOffset, kvLength);
        if (includesMvccVersion) {
            long mvccVersion = ByteBufferUtils.readVLong(bb);
            keyValue.setSequenceId(mvccVersion);
        }
        return keyValue;
    }

    public static KeyValue previousKey(KeyValue in) {
        return KeyValueUtil.createFirstOnRow(CellUtil.cloneRow(in), CellUtil.cloneFamily(in), CellUtil.cloneQualifier(in), in.getTimestamp() - 1L);
    }

    public static KeyValue createLastOnRow(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MIN_VALUE, KeyValue.Type.Minimum, null, 0, 0);
    }

    public static KeyValue createFirstOnRow(byte[] row, int roffset, short rlength) {
        return new KeyValue(row, roffset, rlength, null, 0, 0, null, 0, 0, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0);
    }

    public static KeyValue createLastOnRow(byte[] row) {
        return new KeyValue(row, null, null, Long.MAX_VALUE, KeyValue.Type.Minimum);
    }

    public static KeyValue createFirstOnRow(byte[] row) {
        return KeyValueUtil.createFirstOnRow(row, Long.MAX_VALUE);
    }

    public static KeyValue createFirstOnRow(byte[] row, long ts) {
        return new KeyValue(row, null, null, ts, KeyValue.Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, byte[] family, byte[] qualifier) {
        return new KeyValue(row, family, qualifier, Long.MAX_VALUE, KeyValue.Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, byte[] f, byte[] q, long ts) {
        return new KeyValue(row, f, q, ts, KeyValue.Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0);
    }

    public static KeyValue createFirstOnRow(byte[] buffer, byte[] row, byte[] family, byte[] qualifier) throws IllegalArgumentException {
        return KeyValueUtil.createFirstOnRow(buffer, 0, row, 0, row.length, family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public static KeyValue createFirstOnRow(byte[] buffer, int boffset, byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) throws IllegalArgumentException {
        long lLength = KeyValue.getKeyValueDataStructureSize(rlength, flength, qlength, 0);
        if (lLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("KeyValue length " + lLength + " > " + Integer.MAX_VALUE);
        }
        int iLength = (int)lLength;
        if (buffer.length - boffset < iLength) {
            throw new IllegalArgumentException("Buffer size " + (buffer.length - boffset) + " < " + iLength);
        }
        int len = KeyValue.writeByteArray(buffer, boffset, row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0, null);
        return new KeyValue(buffer, boffset, len);
    }

    @Deprecated
    public static KeyValue ensureKeyValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell instanceof KeyValue) {
            if (cell.getClass().getName().equals(KeyValue.class.getName())) {
                return (KeyValue)cell;
            }
            KeyValue kv = (KeyValue)cell;
            KeyValue newKv = new KeyValue(kv.bytes, kv.offset, kv.length);
            newKv.setSequenceId(kv.getSequenceId());
            return newKv;
        }
        return KeyValueUtil.copyToNewKeyValue(cell);
    }

    @Deprecated
    public static List<KeyValue> ensureKeyValues(List<Cell> cells) {
        List<KeyValue> lazyList = Lists.transform(cells, new Function<Cell, KeyValue>(){

            @Override
            public KeyValue apply(Cell arg0) {
                return KeyValueUtil.ensureKeyValue(arg0);
            }
        });
        return new ArrayList<KeyValue>(lazyList);
    }

    public static long write(KeyValue kv, DataOutput out) throws IOException {
        int length2 = kv.getLength();
        out.writeInt(length2);
        out.write(kv.getBuffer(), kv.getOffset(), length2);
        return (long)length2 + 4L;
    }

    static String bytesToHex(byte[] buf, int offset2, int length2) {
        String bufferContents = buf != null ? Bytes.toStringBinary(buf, offset2, length2) : "<null>";
        return ", KeyValueBytesHex=" + bufferContents + ", offset=" + offset2 + ", length=" + length2;
    }

    static void checkKeyValueBytes(byte[] buf, int offset2, int length2, boolean withTags) {
        if (buf == null) {
            String msg = "Invalid to have null byte array in KeyValue.";
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        int pos2 = offset2;
        int endOffset = offset2 + length2;
        if (pos2 + 4 > endOffset) {
            String msg = "Overflow when reading key length at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        int keyLen = Bytes.toInt(buf, pos2, 4);
        if (keyLen <= 0 || (pos2 += 4) + keyLen > endOffset) {
            String msg = "Invalid key length in KeyValue. keyLength=" + keyLen + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (pos2 + 4 > endOffset) {
            String msg = "Overflow when reading value length at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        int valLen = Bytes.toInt(buf, pos2, 4);
        if (valLen < 0 || (pos2 += 4) + valLen > endOffset) {
            String msg = "Invalid value length in KeyValue, valueLength=" + valLen + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (pos2 + 2 > endOffset) {
            String msg = "Overflow when reading row length at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        short rowLen = Bytes.toShort(buf, pos2, 2);
        if (rowLen < 0 || (pos2 += 2) + rowLen > endOffset) {
            String msg = "Invalid row length in KeyValue, rowLength=" + rowLen + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if ((pos2 += rowLen) + 1 > endOffset) {
            String msg = "Overflow when reading family length at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        byte familyLen = buf[pos2];
        if (familyLen < 0 || ++pos2 + familyLen > endOffset) {
            String msg = "Invalid family length in KeyValue, familyLength=" + familyLen + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        int qualifierLen = keyLen - 2 - rowLen - 1 - familyLen - 8 - 1;
        if (qualifierLen < 0 || (pos2 += familyLen) + qualifierLen > endOffset) {
            String msg = "Invalid qualifier length in KeyValue, qualifierLen=" + qualifierLen + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if ((pos2 += qualifierLen) + 8 > endOffset) {
            String msg = "Overflow when reading timestamp at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        long timestamp = Bytes.toLong(buf, pos2, 8);
        if (timestamp < 0L) {
            String msg = "Timestamp cannot be negative, ts=" + timestamp + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if ((pos2 += 8) + 1 > endOffset) {
            String msg = "Overflow when reading type at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        byte type2 = buf[pos2];
        if (!KeyValue.Type.isValidType(type2)) {
            String msg = "Invalid type in KeyValue, type=" + type2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (++pos2 + valLen > endOffset) {
            String msg = "Overflow when reading value part at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        pos2 += valLen;
        if (withTags) {
            if (pos2 == endOffset) {
                return;
            }
            pos2 = KeyValueUtil.checkKeyValueTagBytes(buf, offset2, length2, pos2, endOffset);
        }
        if (pos2 != endOffset) {
            String msg = "Some redundant bytes in KeyValue's buffer, startOffset=" + pos2 + ", endOffset=" + endOffset + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private static int checkKeyValueTagBytes(byte[] buf, int offset2, int length2, int pos2, int endOffset) {
        if (pos2 + 2 > endOffset) {
            String msg = "Overflow when reading tags length at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        short tagsLen = Bytes.toShort(buf, pos2);
        if (tagsLen < 0 || (pos2 += 2) + tagsLen > endOffset) {
            String msg = "Invalid tags length in KeyValue at position=" + (pos2 - 2) + KeyValueUtil.bytesToHex(buf, offset2, length2);
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        int tagsEndOffset = pos2 + tagsLen;
        while (pos2 < tagsEndOffset) {
            if (pos2 + 2 > endOffset) {
                String msg = "Overflow when reading tag length at position=" + pos2 + KeyValueUtil.bytesToHex(buf, offset2, length2);
                LOG.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            short tagLen = Bytes.toShort(buf, pos2);
            if (tagLen < 1 || (pos2 += 2) + tagLen > endOffset) {
                String msg = "Invalid tag length at position=" + (pos2 - 2) + ", tagLength=" + tagLen + KeyValueUtil.bytesToHex(buf, offset2, length2);
                LOG.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            pos2 += tagLen;
        }
        return pos2;
    }

    public static KeyValue createKeyValueFromInputStream(InputStream in, boolean withTags) throws IOException {
        int n;
        byte[] intBytes = new byte[4];
        for (int bytesRead = 0; bytesRead < intBytes.length; bytesRead += n) {
            n = in.read(intBytes, bytesRead, intBytes.length - bytesRead);
            if (n >= 0) continue;
            if (bytesRead == 0) {
                throw new EOFException();
            }
            throw new IOException("Failed read of int, read " + bytesRead + " bytes");
        }
        byte[] bytes2 = new byte[Bytes.toInt(intBytes)];
        IOUtils.readFully((InputStream)in, (byte[])bytes2, (int)0, (int)bytes2.length);
        return withTags ? new KeyValue(bytes2, 0, bytes2.length) : new NoTagsKeyValue(bytes2, 0, bytes2.length);
    }

    public static KeyValue createKeyValueFromKey(byte[] b) {
        return KeyValueUtil.createKeyValueFromKey(b, 0, b.length);
    }

    public static KeyValue createKeyValueFromKey(ByteBuffer bb) {
        return KeyValueUtil.createKeyValueFromKey(bb.array(), bb.arrayOffset(), bb.limit());
    }

    public static KeyValue createKeyValueFromKey(byte[] b, int o, int l) {
        byte[] newb = new byte[l + 8];
        System.arraycopy(b, o, newb, 8, l);
        Bytes.putInt(newb, 0, l);
        Bytes.putInt(newb, 4, 0);
        return new KeyValue(newb);
    }

    public static KeyValue create(DataInput in) throws IOException {
        return KeyValueUtil.create(in.readInt(), in);
    }

    public static KeyValue create(int length2, DataInput in) throws IOException {
        if (length2 <= 0) {
            if (length2 == 0) {
                return null;
            }
            throw new IOException("Failed read " + length2 + " bytes, stream corrupt?");
        }
        byte[] bytes2 = new byte[length2];
        in.readFully(bytes2);
        return new KeyValue(bytes2, 0, length2);
    }

    public static int getSerializedSize(Cell cell, boolean withTags) {
        if (withTags) {
            return cell.getSerializedSize();
        }
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).getSerializedSize(withTags);
        }
        return KeyValueUtil.length(cell.getRowLength(), cell.getFamilyLength(), cell.getQualifierLength(), cell.getValueLength(), cell.getTagsLength(), withTags);
    }

    public static int oswrite(Cell cell, OutputStream out, boolean withTags) throws IOException {
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).write(out, withTags);
        }
        short rlen = cell.getRowLength();
        byte flen = cell.getFamilyLength();
        int qlen = cell.getQualifierLength();
        int vlen = cell.getValueLength();
        int tlen = cell.getTagsLength();
        int size2 = 0;
        int klen = KeyValueUtil.keyLength(rlen, flen, qlen);
        ByteBufferUtils.putInt(out, klen);
        ByteBufferUtils.putInt(out, vlen);
        StreamUtils.writeShort(out, rlen);
        out.write(cell.getRowArray(), cell.getRowOffset(), rlen);
        out.write(flen);
        out.write(cell.getFamilyArray(), cell.getFamilyOffset(), flen);
        out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qlen);
        StreamUtils.writeLong(out, cell.getTimestamp());
        out.write(cell.getTypeByte());
        out.write(cell.getValueArray(), cell.getValueOffset(), vlen);
        size2 = klen + vlen + 8;
        if (withTags && tlen > 0) {
            out.write((byte)(0xFF & tlen >> 8));
            out.write((byte)(0xFF & tlen));
            out.write(cell.getTagsArray(), cell.getTagsOffset(), tlen);
            size2 += tlen + 2;
        }
        return size2;
    }
}

