/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class TagUtil {
    static final Iterator<Tag> EMPTY_TAGS_ITR = new Iterator<Tag>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        @SuppressWarnings(value={"IT_NO_SUCH_ELEMENT"}, justification="Intentional")
        public Tag next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private TagUtil() {
    }

    public static List<Tag> asList(byte[] b, int offset2, int length2) {
        int tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int pos2 = offset2; pos2 < offset2 + length2; pos2 += 2 + tagLen) {
            tagLen = Bytes.readAsInt(b, pos2, 2);
            tags.add(new ArrayBackedTag(b, pos2, tagLen + 2));
        }
        return tags;
    }

    public static Pair<Integer, Integer> readVIntValuePart(Tag tag2, int offset2) throws IOException {
        if (tag2.hasArray()) {
            return StreamUtils.readRawVarint32(tag2.getValueArray(), offset2);
        }
        return StreamUtils.readRawVarint32(tag2.getValueByteBuffer(), offset2);
    }

    public static List<Tag> carryForwardTags(Cell cell) {
        return TagUtil.carryForwardTags(null, cell);
    }

    public static List<Tag> carryForwardTags(List<Tag> tagsOrNull, Cell cell) {
        Iterator<Tag> itr = PrivateCellUtil.tagsIterator(cell);
        if (itr == EMPTY_TAGS_ITR) {
            return tagsOrNull;
        }
        List<Tag> tags = tagsOrNull;
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        while (itr.hasNext()) {
            tags.add(itr.next());
        }
        return tags;
    }

    public static byte[] concatTags(byte[] tags, Cell cell) {
        int cellTagsLen = cell.getTagsLength();
        if (cellTagsLen == 0) {
            return tags;
        }
        byte[] b = new byte[tags.length + cellTagsLen];
        int pos2 = Bytes.putBytes(b, 0, tags, 0, tags.length);
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToArray(b, ((ByteBufferExtendedCell)cell).getTagsByteBuffer(), ((ByteBufferExtendedCell)cell).getTagsPosition(), pos2, cellTagsLen);
        } else {
            Bytes.putBytes(b, pos2, cell.getTagsArray(), cell.getTagsOffset(), cellTagsLen);
        }
        return b;
    }

    public static List<Tag> carryForwardTTLTag(List<Tag> tagsOrNull, long ttl) {
        if (ttl == Long.MAX_VALUE) {
            return tagsOrNull;
        }
        List<Tag> tags = tagsOrNull;
        if (tags == null) {
            tags = new ArrayList<Tag>(1);
        } else {
            Iterator<Tag> tagsItr = tags.iterator();
            while (tagsItr.hasNext()) {
                Tag tag2 = tagsItr.next();
                if (tag2.getType() != 8) continue;
                tagsItr.remove();
                break;
            }
        }
        tags.add(new ArrayBackedTag(8, Bytes.toBytes(ttl)));
        return tags;
    }

    public static byte[] fromList(List<Tag> tags) {
        if (tags == null || tags.isEmpty()) {
            return HConstants.EMPTY_BYTE_ARRAY;
        }
        int length2 = 0;
        for (Tag tag2 : tags) {
            length2 += tag2.getValueLength() + 3;
        }
        byte[] b = new byte[length2];
        int pos2 = 0;
        for (Tag tag3 : tags) {
            int tlen = tag3.getValueLength();
            pos2 = Bytes.putAsShort(b, pos2, tlen + 1);
            pos2 = Bytes.putByte(b, pos2, tag3.getType());
            if (tag3.hasArray()) {
                pos2 = Bytes.putBytes(b, pos2, tag3.getValueArray(), tag3.getValueOffset(), tlen);
                continue;
            }
            ByteBufferUtils.copyFromBufferToArray(b, tag3.getValueByteBuffer(), tag3.getValueOffset(), pos2, tlen);
            pos2 += tlen;
        }
        return b;
    }
}

