/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AllowPartialScanResultCache
implements ScanResultCache {
    private Cell lastCell;
    private boolean lastResultPartial;
    private int numberOfCompleteRows;

    AllowPartialScanResultCache() {
    }

    private void recordLastResult(Result result2) {
        this.lastCell = result2.rawCells()[result2.rawCells().length - 1];
        this.lastResultPartial = result2.mayHaveMoreCellsInRow();
    }

    @Override
    public Result[] addAndGet(Result[] results, boolean isHeartbeatMessage) throws IOException {
        int i2;
        if (results.length == 0) {
            if (!isHeartbeatMessage && this.lastResultPartial) {
                ++this.numberOfCompleteRows;
            }
            return EMPTY_RESULT_ARRAY;
        }
        for (i2 = 0; i2 < results.length; ++i2) {
            Result r = ConnectionUtils.filterCells(results[i2], this.lastCell);
            if (r == null) continue;
            results[i2] = r;
            break;
        }
        if (i2 == results.length) {
            return EMPTY_RESULT_ARRAY;
        }
        if (this.lastResultPartial && !CellUtil.matchingRows(this.lastCell, results[0].getRow())) {
            ++this.numberOfCompleteRows;
        }
        this.recordLastResult(results[results.length - 1]);
        if (i2 > 0) {
            results = Arrays.copyOfRange(results, i2, results.length);
        }
        for (Result result2 : results) {
            if (result2.mayHaveMoreCellsInRow()) continue;
            ++this.numberOfCompleteRows;
        }
        return results;
    }

    @Override
    public void clear() {
    }

    @Override
    public int numberOfCompleteRows() {
        return this.numberOfCompleteRows;
    }
}

