/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.client.ClientIdGenerator;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class PerClientRandomNonceGenerator
implements NonceGenerator {
    private static final PerClientRandomNonceGenerator INST = new PerClientRandomNonceGenerator();
    private final long clientId;

    private PerClientRandomNonceGenerator() {
        byte[] clientIdBase = ClientIdGenerator.generateClientId();
        this.clientId = ((long)Arrays.hashCode(clientIdBase) << 32) + (long)ThreadLocalRandom.current().nextInt();
    }

    @Override
    public long getNonceGroup() {
        return this.clientId;
    }

    @Override
    public long newNonce() {
        long result2 = 0L;
        while ((result2 = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return result2;
    }

    public static PerClientRandomNonceGenerator get() {
        return INST;
    }
}

