/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class TableBuilderBase
implements TableBuilder {
    protected TableName tableName;
    protected int operationTimeout;
    protected int rpcTimeout;
    protected int readRpcTimeout;
    protected int writeRpcTimeout;

    TableBuilderBase(TableName tableName, ConnectionConfiguration connConf) {
        if (tableName == null) {
            throw new IllegalArgumentException("Given table name is null");
        }
        this.tableName = tableName;
        this.operationTimeout = tableName.isSystemTable() ? connConf.getMetaOperationTimeout() : connConf.getOperationTimeout();
        this.rpcTimeout = connConf.getRpcTimeout();
        this.readRpcTimeout = connConf.getReadRpcTimeout();
        this.writeRpcTimeout = connConf.getWriteRpcTimeout();
    }

    @Override
    public TableBuilderBase setOperationTimeout(int timeout2) {
        this.operationTimeout = timeout2;
        return this;
    }

    @Override
    public TableBuilderBase setRpcTimeout(int timeout2) {
        this.rpcTimeout = timeout2;
        return this;
    }

    @Override
    public TableBuilderBase setReadRpcTimeout(int timeout2) {
        this.readRpcTimeout = timeout2;
        return this;
    }

    @Override
    public TableBuilderBase setWriteRpcTimeout(int timeout2) {
        this.writeRpcTimeout = timeout2;
        return this;
    }
}

