/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class FuzzyRowFilter
extends FilterBase {
    private static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();
    static final byte V1_PROCESSED_WILDCARD_MASK = 0;
    static final byte V2_PROCESSED_WILDCARD_MASK = 2;
    private final byte processedWildcardMask;
    private List<Pair<byte[], byte[]>> fuzzyKeysData;
    private boolean done = false;
    private int lastFoundIndex = -1;
    private RowTracker tracker;

    public FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData) {
        this(fuzzyKeysData, 2);
    }

    FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData, byte processedWildcardMask) {
        this.processedWildcardMask = processedWildcardMask;
        ArrayList<Pair<byte[], byte[]>> fuzzyKeyDataCopy = new ArrayList<Pair<byte[], byte[]>>(fuzzyKeysData.size());
        for (Pair<byte[], byte[]> aFuzzyKeysData : fuzzyKeysData) {
            if (aFuzzyKeysData.getFirst().length != aFuzzyKeysData.getSecond().length) {
                Pair<String, String> readable = new Pair<String, String>(Bytes.toStringBinary(aFuzzyKeysData.getFirst()), Bytes.toStringBinary(aFuzzyKeysData.getSecond()));
                throw new IllegalArgumentException("Fuzzy pair lengths do not match: " + readable);
            }
            Pair<byte[], byte[]> p2 = new Pair<byte[], byte[]>();
            p2.setFirst(Arrays.copyOf(aFuzzyKeysData.getFirst(), aFuzzyKeysData.getFirst().length));
            p2.setSecond(Arrays.copyOf(aFuzzyKeysData.getSecond(), aFuzzyKeysData.getSecond().length));
            p2.setSecond(this.preprocessMask((byte[])p2.getSecond()));
            this.preprocessSearchKey(p2);
            fuzzyKeyDataCopy.add(p2);
        }
        this.fuzzyKeysData = fuzzyKeyDataCopy;
        this.tracker = new RowTracker();
    }

    private void preprocessSearchKey(Pair<byte[], byte[]> p2) {
        if (!UNSAFE_UNALIGNED) {
            return;
        }
        byte[] key2 = p2.getFirst();
        byte[] mask = p2.getSecond();
        for (int i2 = 0; i2 < mask.length; ++i2) {
            if (mask[i2] != this.processedWildcardMask) continue;
            key2[i2] = 0;
        }
    }

    private byte[] preprocessMask(byte[] mask) {
        if (!UNSAFE_UNALIGNED) {
            return mask;
        }
        if (this.isPreprocessedMask(mask)) {
            return mask;
        }
        for (int i2 = 0; i2 < mask.length; ++i2) {
            if (mask[i2] == 0) {
                mask[i2] = -1;
                continue;
            }
            if (mask[i2] != 1) continue;
            mask[i2] = this.processedWildcardMask;
        }
        return mask;
    }

    private boolean isPreprocessedMask(byte[] mask) {
        for (int i2 = 0; i2 < mask.length; ++i2) {
            if (mask[i2] == -1 || mask[i2] == this.processedWildcardMask) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        int startIndex = this.lastFoundIndex >= 0 ? this.lastFoundIndex : 0;
        int size2 = this.fuzzyKeysData.size();
        for (int i2 = startIndex; i2 < size2 + startIndex; ++i2) {
            int index2 = i2 % size2;
            Pair<byte[], byte[]> fuzzyData = this.fuzzyKeysData.get(index2);
            FuzzyRowFilter.idempotentMaskShift(fuzzyData.getSecond());
            SatisfiesCode satisfiesCode = FuzzyRowFilter.satisfies(this.isReversed(), c.getRowArray(), c.getRowOffset(), c.getRowLength(), fuzzyData.getFirst(), fuzzyData.getSecond());
            if (satisfiesCode != SatisfiesCode.YES) continue;
            this.lastFoundIndex = index2;
            return Filter.ReturnCode.INCLUDE;
        }
        this.lastFoundIndex = -1;
        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
    }

    static void idempotentMaskShift(byte[] mask) {
        int j = 0;
        while (j < mask.length) {
            int n = j++;
            mask[n] = (byte)(mask[n] >> 2);
        }
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) {
        boolean result2 = this.tracker.updateTracker(currentCell);
        if (!result2) {
            this.done = true;
            return null;
        }
        byte[] nextRowKey = this.tracker.nextRow();
        return PrivateCellUtil.createFirstOnRow(nextRowKey, 0, (short)nextRowKey.length);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FuzzyRowFilter.Builder builder = FilterProtos.FuzzyRowFilter.newBuilder().setIsMaskV2(this.processedWildcardMask == 2);
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            bbpBuilder.setFirst(UnsafeByteOperations.unsafeWrap(fuzzyData.getFirst()));
            bbpBuilder.setSecond(UnsafeByteOperations.unsafeWrap(fuzzyData.getSecond()));
            builder.addFuzzyKeysData(bbpBuilder);
        }
        return builder.build().toByteArray();
    }

    public static FuzzyRowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FuzzyRowFilter proto;
        try {
            proto = FilterProtos.FuzzyRowFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int count2 = proto.getFuzzyKeysDataCount();
        ArrayList<Pair<byte[], byte[]>> fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            HBaseProtos.BytesBytesPair current2 = proto.getFuzzyKeysData(i2);
            byte[] keyBytes = current2.getFirst().toByteArray();
            byte[] keyMeta = current2.getSecond().toByteArray();
            fuzzyKeysData.add(new Pair<byte[], byte[]>(keyBytes, keyMeta));
        }
        byte processedWildcardMask = proto.hasIsMaskV2() && proto.getIsMaskV2() ? (byte)2 : 0;
        return new FuzzyRowFilter(fuzzyKeysData, processedWildcardMask);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FuzzyRowFilter");
        sb.append("{fuzzyKeysData=");
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            sb.append('{').append(Bytes.toStringBinary(fuzzyData.getFirst())).append(":");
            sb.append(Bytes.toStringBinary(fuzzyData.getSecond())).append('}');
        }
        sb.append("}, ");
        return sb.toString();
    }

    @InterfaceAudience.Private
    static SatisfiesCode satisfies(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @InterfaceAudience.Private
    static SatisfiesCode satisfies(boolean reverse2, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(reverse2, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    static SatisfiesCode satisfies(boolean reverse2, byte[] row, int offset2, int length2, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int fuzzyBytes;
        int rowValue;
        int fuzzyMeta;
        if (!UNSAFE_UNALIGNED) {
            return FuzzyRowFilter.satisfiesNoUnsafe(reverse2, row, offset2, length2, fuzzyKeyBytes, fuzzyKeyMeta);
        }
        if (row == null) {
            return SatisfiesCode.YES;
        }
        length2 = Math.min(length2, fuzzyKeyBytes.length);
        int numWords = length2 / 8;
        int j = numWords << 3;
        for (int i2 = 0; i2 < j; i2 += 8) {
            long fuzzyBytes2 = Bytes.toLong(fuzzyKeyBytes, i2);
            long fuzzyMeta2 = Bytes.toLong(fuzzyKeyMeta, i2);
            long rowValue2 = Bytes.toLong(row, offset2 + i2);
            if ((rowValue2 & fuzzyMeta2) == fuzzyBytes2) continue;
            return SatisfiesCode.NEXT_EXISTS;
        }
        int off = j;
        if (length2 - off >= 4) {
            int fuzzyBytes3 = Bytes.toInt(fuzzyKeyBytes, off);
            fuzzyMeta = Bytes.toInt(fuzzyKeyMeta, off);
            int rowValue3 = Bytes.toInt(row, offset2 + off);
            if ((rowValue3 & fuzzyMeta) != fuzzyBytes3) {
                return SatisfiesCode.NEXT_EXISTS;
            }
            off += 4;
        }
        if (length2 - off >= 2) {
            short fuzzyBytes4 = Bytes.toShort(fuzzyKeyBytes, off);
            fuzzyMeta = Bytes.toShort(fuzzyKeyMeta, off);
            short rowValue4 = Bytes.toShort(row, offset2 + off);
            if ((rowValue4 & fuzzyMeta) != fuzzyBytes4) {
                return SatisfiesCode.NEXT_EXISTS;
            }
            off += 2;
        }
        if (length2 - off >= 1 && ((rowValue = row[offset2 + off] & 0xFF) & (fuzzyMeta = fuzzyKeyMeta[off] & 0xFF)) != (fuzzyBytes = fuzzyKeyBytes[off] & 0xFF)) {
            return SatisfiesCode.NEXT_EXISTS;
        }
        return SatisfiesCode.YES;
    }

    static SatisfiesCode satisfiesNoUnsafe(boolean reverse2, byte[] row, int offset2, int length2, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        if (row == null) {
            return SatisfiesCode.YES;
        }
        Order order2 = Order.orderFor(reverse2);
        boolean nextRowKeyCandidateExists = false;
        for (int i2 = 0; i2 < fuzzyKeyMeta.length && i2 < length2; ++i2) {
            boolean fixedByteIncorrect;
            boolean byteAtPositionFixed = fuzzyKeyMeta[i2] == 0;
            boolean bl = fixedByteIncorrect = byteAtPositionFixed && fuzzyKeyBytes[i2] != row[i2 + offset2];
            if (fixedByteIncorrect) {
                boolean rowByteLessThanFixed;
                if (nextRowKeyCandidateExists) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                boolean bl2 = rowByteLessThanFixed = (row[i2 + offset2] & 0xFF) < (fuzzyKeyBytes[i2] & 0xFF);
                if (rowByteLessThanFixed && !reverse2) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                if (!rowByteLessThanFixed && reverse2) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                return SatisfiesCode.NO_NEXT;
            }
            if (fuzzyKeyMeta[i2] != 1 || order2.isMax(fuzzyKeyBytes[i2])) continue;
            nextRowKeyCandidateExists = true;
        }
        return SatisfiesCode.YES;
    }

    @InterfaceAudience.Private
    static byte[] getNextForFuzzyRule(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @InterfaceAudience.Private
    static byte[] getNextForFuzzyRule(boolean reverse2, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(reverse2, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @InterfaceAudience.Private
    static byte[] getNextForFuzzyRule(boolean reverse2, byte[] row, int offset2, int length2, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int i2;
        byte[] result2 = Arrays.copyOf(fuzzyKeyBytes, length2 > fuzzyKeyBytes.length ? length2 : fuzzyKeyBytes.length);
        if (reverse2 && length2 > fuzzyKeyBytes.length) {
            for (int i3 = fuzzyKeyBytes.length; i3 < result2.length; ++i3) {
                result2[i3] = -1;
            }
        }
        int toInc = -1;
        Order order2 = Order.orderFor(reverse2);
        boolean increased = false;
        for (i2 = 0; i2 < result2.length; ++i2) {
            if (i2 >= fuzzyKeyMeta.length || fuzzyKeyMeta[i2] == 0) {
                result2[i2] = row[offset2 + i2];
                if (order2.isMax(row[offset2 + i2])) continue;
                toInc = i2;
                continue;
            }
            if (i2 >= fuzzyKeyMeta.length || fuzzyKeyMeta[i2] != -1) continue;
            if (order2.lt(row[i2 + offset2] & 0xFF, fuzzyKeyBytes[i2] & 0xFF)) {
                increased = true;
                break;
            }
            if (order2.gt(row[i2 + offset2] & 0xFF, fuzzyKeyBytes[i2] & 0xFF)) break;
        }
        if (!increased) {
            if (toInc < 0) {
                return null;
            }
            result2[toInc] = order2.inc(result2[toInc]);
            for (i2 = toInc + 1; i2 < result2.length; ++i2) {
                if (i2 < fuzzyKeyMeta.length && fuzzyKeyMeta[i2] != 0) continue;
                result2[i2] = order2.min();
            }
        }
        return reverse2 ? result2 : FuzzyRowFilter.trimTrailingZeroes(result2, fuzzyKeyMeta, toInc);
    }

    private static byte[] trimTrailingZeroes(byte[] result2, byte[] fuzzyKeyMeta, int toInc) {
        int off;
        int n = off = fuzzyKeyMeta.length >= result2.length ? result2.length - 1 : fuzzyKeyMeta.length - 1;
        while (off >= 0 && fuzzyKeyMeta[off] == 0) {
            --off;
        }
        if (off < toInc) {
            off = toInc;
        }
        byte[] retValue = new byte[off + 1];
        System.arraycopy(result2, 0, retValue, 0, retValue.length);
        return retValue;
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuzzyRowFilter)) {
            return false;
        }
        FuzzyRowFilter other = (FuzzyRowFilter)o;
        if (this.fuzzyKeysData.size() != other.fuzzyKeysData.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.fuzzyKeysData.size(); ++i2) {
            Pair<byte[], byte[]> thisData = this.fuzzyKeysData.get(i2);
            Pair<byte[], byte[]> otherData = other.fuzzyKeysData.get(i2);
            if (Bytes.equals(thisData.getFirst(), otherData.getFirst()) && Bytes.equals(thisData.getSecond(), otherData.getSecond())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(this.fuzzyKeysData);
    }

    private static enum Order {
        ASC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val + 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == -1;
            }

            @Override
            public byte min() {
                return 0;
            }
        }
        ,
        DESC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val - 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == 0;
            }

            @Override
            public byte min() {
                return -1;
            }
        };


        public static Order orderFor(boolean reverse2) {
            return reverse2 ? DESC : ASC;
        }

        public abstract boolean lt(int var1, int var2);

        public abstract boolean gt(int var1, int var2);

        public abstract byte inc(byte var1);

        public abstract boolean isMax(byte var1);

        public abstract byte min();
    }

    static enum SatisfiesCode {
        YES,
        NEXT_EXISTS,
        NO_NEXT;

    }

    private class RowTracker {
        private final PriorityQueue<Pair<byte[], Pair<byte[], byte[]>>> nextRows;
        private boolean initialized = false;

        RowTracker() {
            this.nextRows = new PriorityQueue<Pair<byte[], Pair<byte[], byte[]>>>(FuzzyRowFilter.this.fuzzyKeysData.size(), new Comparator<Pair<byte[], Pair<byte[], byte[]>>>(){

                @Override
                public int compare(Pair<byte[], Pair<byte[], byte[]>> o1, Pair<byte[], Pair<byte[], byte[]>> o2) {
                    return FuzzyRowFilter.this.isReversed() ? Bytes.compareTo(o2.getFirst(), o1.getFirst()) : Bytes.compareTo(o1.getFirst(), o2.getFirst());
                }
            });
        }

        byte[] nextRow() {
            if (this.nextRows.isEmpty()) {
                throw new IllegalStateException("NextRows should not be empty, make sure to call nextRow() after updateTracker() return true");
            }
            return this.nextRows.peek().getFirst();
        }

        boolean updateTracker(Cell currentCell) {
            if (!this.initialized) {
                for (Pair fuzzyData : FuzzyRowFilter.this.fuzzyKeysData) {
                    this.updateWith(currentCell, fuzzyData);
                }
                this.initialized = true;
            } else {
                while (!this.nextRows.isEmpty() && !this.lessThan(currentCell, this.nextRows.peek().getFirst())) {
                    Pair<byte[], Pair<byte[], byte[]>> head = this.nextRows.poll();
                    Pair<byte[], byte[]> fuzzyData = head.getSecond();
                    this.updateWith(currentCell, fuzzyData);
                }
            }
            return !this.nextRows.isEmpty();
        }

        boolean lessThan(Cell currentCell, byte[] nextRowKey) {
            int compareResult = CellComparator.getInstance().compareRows(currentCell, nextRowKey, 0, nextRowKey.length);
            return !FuzzyRowFilter.this.isReversed() && compareResult < 0 || FuzzyRowFilter.this.isReversed() && compareResult > 0;
        }

        void updateWith(Cell currentCell, Pair<byte[], byte[]> fuzzyData) {
            byte[] nextRowKeyCandidate = FuzzyRowFilter.getNextForFuzzyRule(FuzzyRowFilter.this.isReversed(), currentCell.getRowArray(), currentCell.getRowOffset(), currentCell.getRowLength(), fuzzyData.getFirst(), fuzzyData.getSecond());
            if (nextRowKeyCandidate != null) {
                this.nextRows.add(new Pair<byte[], Pair<byte[], byte[]>>(nextRowKeyCandidate, fuzzyData));
            }
        }
    }
}

