/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.RefCnt;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MultiByteBuff
extends ByteBuff {
    private final ByteBuffer[] items;
    private ByteBuffer curItem = null;
    private int curItemIndex = 0;
    private int limit = 0;
    private int limitedItemIndex;
    private int markedItemIndex = -1;
    private final int[] itemBeginPos;
    private Iterator<ByteBuffer> buffsIterator = new Iterator<ByteBuffer>(){

        @Override
        public boolean hasNext() {
            return MultiByteBuff.this.curItemIndex < MultiByteBuff.this.limitedItemIndex || MultiByteBuff.this.curItemIndex == MultiByteBuff.this.limitedItemIndex && MultiByteBuff.this.items[MultiByteBuff.this.curItemIndex].hasRemaining();
        }

        @Override
        public ByteBuffer next() {
            if (MultiByteBuff.this.curItemIndex >= MultiByteBuff.this.items.length) {
                throw new NoSuchElementException("items overflow");
            }
            MultiByteBuff.this.curItem = MultiByteBuff.this.items[MultiByteBuff.this.curItemIndex++];
            return MultiByteBuff.this.curItem;
        }
    };

    public MultiByteBuff(ByteBuffer ... items) {
        this(ByteBuffAllocator.NONE, items);
    }

    public MultiByteBuff(ByteBuffAllocator.Recycler recycler, ByteBuffer ... items) {
        this(new RefCnt(recycler), items);
    }

    MultiByteBuff(RefCnt refCnt, ByteBuffer ... items) {
        this.refCnt = refCnt;
        assert (items != null);
        assert (items.length > 0);
        this.items = items;
        this.curItem = this.items[this.curItemIndex];
        this.itemBeginPos = new int[items.length + 1];
        int offset2 = 0;
        for (int i2 = 0; i2 < items.length; ++i2) {
            ByteBuffer item = items[i2];
            item.rewind();
            this.itemBeginPos[i2] = offset2;
            int l = item.limit() - item.position();
            offset2 += l;
        }
        this.limit = offset2;
        this.itemBeginPos[items.length] = offset2 + 1;
        this.limitedItemIndex = this.items.length - 1;
    }

    private MultiByteBuff(RefCnt refCnt, ByteBuffer[] items, int[] itemBeginPos, int limit2, int limitedIndex, int curItemIndex, int markedIndex) {
        this.refCnt = refCnt;
        this.items = items;
        this.curItemIndex = curItemIndex;
        this.curItem = this.items[this.curItemIndex];
        this.itemBeginPos = itemBeginPos;
        this.limit = limit2;
        this.limitedItemIndex = limitedIndex;
        this.markedItemIndex = markedIndex;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public int capacity() {
        this.checkRefCount();
        int c = 0;
        for (ByteBuffer item : this.items) {
            c += item.capacity();
        }
        return c;
    }

    @Override
    public byte get(int index2) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(index2);
        return ByteBufferUtils.toByte(this.items[itemIndex], index2 - this.itemBeginPos[itemIndex]);
    }

    @Override
    public byte getByteAfterPosition(int offset2) {
        this.checkRefCount();
        int index2 = offset2 + this.position();
        int itemIndex = this.getItemIndexFromCurItemIndex(index2);
        return ByteBufferUtils.toByte(this.items[itemIndex], index2 - this.itemBeginPos[itemIndex]);
    }

    private int getItemIndex(int elemIndex) {
        if (elemIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int index2 = 1;
        while (elemIndex >= this.itemBeginPos[index2]) {
            if (++index2 != this.itemBeginPos.length) continue;
            throw new IndexOutOfBoundsException();
        }
        return index2 - 1;
    }

    private int getItemIndexFromCurItemIndex(int elemIndex) {
        int index2 = this.curItemIndex;
        while (elemIndex >= this.itemBeginPos[index2]) {
            if (++index2 != this.itemBeginPos.length) continue;
            throw new IndexOutOfBoundsException();
        }
        return index2 - 1;
    }

    @Override
    public int getInt(int index2) {
        this.checkRefCount();
        int itemIndex = this.itemBeginPos[this.curItemIndex] <= index2 && this.itemBeginPos[this.curItemIndex + 1] > index2 ? this.curItemIndex : this.getItemIndex(index2);
        return this.getInt(index2, itemIndex);
    }

    @Override
    public int getIntAfterPosition(int offset2) {
        this.checkRefCount();
        int index2 = offset2 + this.position();
        int itemIndex = this.itemBeginPos[this.curItemIndex + 1] > index2 ? this.curItemIndex : this.getItemIndexFromCurItemIndex(index2);
        return this.getInt(index2, itemIndex);
    }

    @Override
    public short getShort(int index2) {
        this.checkRefCount();
        int itemIndex = this.itemBeginPos[this.curItemIndex] <= index2 && this.itemBeginPos[this.curItemIndex + 1] > index2 ? this.curItemIndex : this.getItemIndex(index2);
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index2 - this.itemBeginPos[itemIndex];
        if (item.limit() - offsetInItem >= 2) {
            return ByteBufferUtils.toShort(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        ByteBuffer nextItem = this.items[itemIndex + 1];
        short n = 0;
        n = (short)(n ^ ByteBufferUtils.toByte(item, offsetInItem) & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ ByteBufferUtils.toByte(nextItem, 0) & 0xFF);
        return n;
    }

    @Override
    public short getShortAfterPosition(int offset2) {
        this.checkRefCount();
        int index2 = offset2 + this.position();
        int itemIndex = this.itemBeginPos[this.curItemIndex + 1] > index2 ? this.curItemIndex : this.getItemIndexFromCurItemIndex(index2);
        return this.getShort(index2, itemIndex);
    }

    private int getInt(int index2, int itemIndex) {
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index2 - this.itemBeginPos[itemIndex];
        int remainingLen = item.limit() - offsetInItem;
        if (remainingLen >= 4) {
            return ByteBufferUtils.toInt(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        int l = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            l <<= 8;
            l ^= this.get(index2 + i2) & 0xFF;
        }
        return l;
    }

    private short getShort(int index2, int itemIndex) {
        int i2;
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index2 - this.itemBeginPos[itemIndex];
        int remainingLen = item.limit() - offsetInItem;
        if (remainingLen >= 2) {
            return ByteBufferUtils.toShort(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        ByteBuffer nextItem = this.items[itemIndex + 1];
        short l = 0;
        for (i2 = offsetInItem; i2 < item.capacity(); ++i2) {
            l = (short)(l << 8);
            l = (short)(l ^ ByteBufferUtils.toByte(item, i2) & 0xFF);
        }
        for (i2 = 0; i2 < 2 - remainingLen; ++i2) {
            l = (short)(l << 8);
            l = (short)(l ^ ByteBufferUtils.toByte(nextItem, i2) & 0xFF);
        }
        return l;
    }

    private long getLong(int index2, int itemIndex) {
        ByteBuffer item = this.items[itemIndex];
        int offsetInItem = index2 - this.itemBeginPos[itemIndex];
        int remainingLen = item.limit() - offsetInItem;
        if (remainingLen >= 8) {
            return ByteBufferUtils.toLong(item, offsetInItem);
        }
        if (this.items.length - 1 == itemIndex) {
            throw new BufferUnderflowException();
        }
        long l = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            l <<= 8;
            l ^= (long)(this.get(index2 + i2) & 0xFF);
        }
        return l;
    }

    @Override
    public long getLong(int index2) {
        this.checkRefCount();
        int itemIndex = this.itemBeginPos[this.curItemIndex] <= index2 && this.itemBeginPos[this.curItemIndex + 1] > index2 ? this.curItemIndex : this.getItemIndex(index2);
        return this.getLong(index2, itemIndex);
    }

    @Override
    public long getLongAfterPosition(int offset2) {
        this.checkRefCount();
        int index2 = offset2 + this.position();
        int itemIndex = this.itemBeginPos[this.curItemIndex + 1] > index2 ? this.curItemIndex : this.getItemIndexFromCurItemIndex(index2);
        return this.getLong(index2, itemIndex);
    }

    @Override
    public int position() {
        this.checkRefCount();
        return this.itemBeginPos[this.curItemIndex] + this.curItem.position();
    }

    @Override
    public MultiByteBuff position(int position) {
        int i2;
        this.checkRefCount();
        if (this.itemBeginPos[this.curItemIndex] <= position && this.itemBeginPos[this.curItemIndex + 1] > position) {
            this.curItem.position(position - this.itemBeginPos[this.curItemIndex]);
            return this;
        }
        int itemIndex = this.getItemIndex(position);
        for (i2 = 0; i2 < itemIndex; ++i2) {
            this.items[i2].position(this.items[i2].limit());
        }
        for (i2 = itemIndex + 1; i2 < this.items.length; ++i2) {
            this.items[i2].position(0);
        }
        this.curItem = this.items[itemIndex];
        this.curItem.position(position - this.itemBeginPos[itemIndex]);
        this.curItemIndex = itemIndex;
        return this;
    }

    @Override
    public MultiByteBuff rewind() {
        this.checkRefCount();
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            this.items[i2].rewind();
        }
        this.curItemIndex = 0;
        this.curItem = this.items[this.curItemIndex];
        this.markedItemIndex = -1;
        return this;
    }

    @Override
    public MultiByteBuff mark() {
        this.checkRefCount();
        this.markedItemIndex = this.curItemIndex;
        this.curItem.mark();
        return this;
    }

    @Override
    public MultiByteBuff reset() {
        this.checkRefCount();
        if (this.markedItemIndex < 0) {
            throw new InvalidMarkException();
        }
        ByteBuffer markedItem = this.items[this.markedItemIndex];
        markedItem.reset();
        this.curItem = markedItem;
        for (int i2 = this.curItemIndex; i2 > this.markedItemIndex; --i2) {
            this.items[i2].position(0);
        }
        this.curItemIndex = this.markedItemIndex;
        return this;
    }

    @Override
    public int remaining() {
        this.checkRefCount();
        int remain = 0;
        for (int i2 = this.curItemIndex; i2 < this.items.length; ++i2) {
            remain += this.items[i2].remaining();
        }
        return remain;
    }

    @Override
    public final boolean hasRemaining() {
        this.checkRefCount();
        return this.curItem.hasRemaining() || this.curItemIndex < this.limitedItemIndex && this.items[this.curItemIndex + 1].hasRemaining();
    }

    @Override
    public byte get() {
        this.checkRefCount();
        if (this.curItem.remaining() == 0) {
            if (this.items.length - 1 == this.curItemIndex) {
                throw new BufferUnderflowException();
            }
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
        }
        return this.curItem.get();
    }

    @Override
    public short getShort() {
        this.checkRefCount();
        int remaining = this.curItem.remaining();
        if (remaining >= 2) {
            return this.curItem.getShort();
        }
        short n = 0;
        n = (short)(n ^ this.get() & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ this.get() & 0xFF);
        return n;
    }

    @Override
    public int getInt() {
        this.checkRefCount();
        int remaining = this.curItem.remaining();
        if (remaining >= 4) {
            return this.curItem.getInt();
        }
        int n = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n <<= 8;
            n ^= this.get() & 0xFF;
        }
        return n;
    }

    @Override
    public long getLong() {
        this.checkRefCount();
        int remaining = this.curItem.remaining();
        if (remaining >= 8) {
            return this.curItem.getLong();
        }
        long l = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            l <<= 8;
            l ^= (long)(this.get() & 0xFF);
        }
        return l;
    }

    @Override
    public void get(byte[] dst) {
        this.get(dst, 0, dst.length);
    }

    @Override
    public void get(byte[] dst, int offset2, int length2) {
        this.checkRefCount();
        while (length2 > 0) {
            int toRead = Math.min(length2, this.curItem.remaining());
            ByteBufferUtils.copyFromBufferToArray(dst, this.curItem, this.curItem.position(), offset2, toRead);
            this.curItem.position(this.curItem.position() + toRead);
            if ((length2 -= toRead) == 0) break;
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
            offset2 += toRead;
        }
    }

    @Override
    public void get(int sourceOffset, byte[] dst, int offset2, int length2) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(sourceOffset);
        ByteBuffer item = this.items[itemIndex];
        sourceOffset -= this.itemBeginPos[itemIndex];
        while (length2 > 0) {
            int toRead = Math.min(item.limit() - sourceOffset, length2);
            ByteBufferUtils.copyFromBufferToArray(dst, item, sourceOffset, offset2, toRead);
            if ((length2 -= toRead) == 0) break;
            item = this.items[++itemIndex];
            offset2 += toRead;
            sourceOffset = 0;
        }
    }

    @Override
    public MultiByteBuff limit(int limit2) {
        int i2;
        this.checkRefCount();
        this.limit = limit2;
        int limitedIndexBegin = this.itemBeginPos[this.limitedItemIndex];
        if (limit2 >= limitedIndexBegin && limit2 < this.itemBeginPos[this.limitedItemIndex + 1]) {
            this.items[this.limitedItemIndex].limit(limit2 - limitedIndexBegin);
            return this;
        }
        int itemIndex = this.getItemIndex(limit2);
        int beginOffset = this.itemBeginPos[itemIndex];
        int offsetInItem = limit2 - beginOffset;
        ByteBuffer item = this.items[itemIndex];
        item.limit(offsetInItem);
        for (i2 = this.limitedItemIndex; i2 < itemIndex; ++i2) {
            this.items[i2].limit(this.items[i2].capacity());
        }
        this.limitedItemIndex = itemIndex;
        for (i2 = itemIndex + 1; i2 < this.items.length; ++i2) {
            this.items[i2].limit(this.items[i2].position());
        }
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public MultiByteBuff slice() {
        this.checkRefCount();
        ByteBuffer[] copy = new ByteBuffer[this.limitedItemIndex - this.curItemIndex + 1];
        int i2 = this.curItemIndex;
        int j = 0;
        while (i2 <= this.limitedItemIndex) {
            copy[j] = this.items[i2].slice();
            ++i2;
            ++j;
        }
        return new MultiByteBuff(this.refCnt, copy);
    }

    @Override
    public MultiByteBuff duplicate() {
        this.checkRefCount();
        ByteBuffer[] itemsCopy = new ByteBuffer[this.items.length];
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            itemsCopy[i2] = this.items[i2].duplicate();
        }
        return new MultiByteBuff(this.refCnt, itemsCopy, this.itemBeginPos, this.limit, this.limitedItemIndex, this.curItemIndex, this.markedItemIndex);
    }

    @Override
    public MultiByteBuff put(byte b) {
        this.checkRefCount();
        if (this.curItem.remaining() == 0) {
            if (this.curItemIndex == this.items.length - 1) {
                throw new BufferOverflowException();
            }
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
        }
        this.curItem.put(b);
        return this;
    }

    @Override
    public MultiByteBuff put(int index2, byte b) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(index2);
        ByteBuffer item = this.items[itemIndex];
        item.put(index2 - this.itemBeginPos[itemIndex], b);
        return this;
    }

    @Override
    public MultiByteBuff put(int destOffset, ByteBuff src, int srcOffset, int length2) {
        this.checkRefCount();
        int destItemIndex = this.getItemIndex(destOffset);
        int srcItemIndex = MultiByteBuff.getItemIndexForByteBuff(src, srcOffset, length2);
        ByteBuffer destItem = this.items[destItemIndex];
        destOffset = this.getRelativeOffset(destOffset, destItemIndex);
        ByteBuffer srcItem = MultiByteBuff.getItemByteBuffer(src, srcItemIndex);
        srcOffset = MultiByteBuff.getRelativeOffsetForByteBuff(src, srcOffset, srcItemIndex);
        while (length2 > 0) {
            int toWrite = destItem.limit() - destOffset;
            if (toWrite <= 0) {
                throw new BufferOverflowException();
            }
            int toRead = srcItem.limit() - srcOffset;
            if (toRead <= 0) {
                throw new BufferUnderflowException();
            }
            int toMove = Math.min(length2, Math.min(toRead, toWrite));
            ByteBufferUtils.copyFromBufferToBuffer(srcItem, destItem, srcOffset, destOffset, toMove);
            if ((length2 -= toMove) == 0) break;
            if (toRead < toWrite) {
                if (++srcItemIndex >= MultiByteBuff.getItemByteBufferCount(src)) {
                    throw new BufferUnderflowException();
                }
                srcItem = MultiByteBuff.getItemByteBuffer(src, srcItemIndex);
                srcOffset = 0;
                destOffset += toMove;
                continue;
            }
            if (toRead > toWrite) {
                if (++destItemIndex >= this.items.length) {
                    throw new BufferOverflowException();
                }
                destItem = this.items[destItemIndex];
                destOffset = 0;
                srcOffset += toMove;
                continue;
            }
            if (++srcItemIndex >= MultiByteBuff.getItemByteBufferCount(src)) {
                throw new BufferUnderflowException();
            }
            srcItem = MultiByteBuff.getItemByteBuffer(src, srcItemIndex);
            srcOffset = 0;
            if (++destItemIndex >= this.items.length) {
                throw new BufferOverflowException();
            }
            destItem = this.items[destItemIndex];
            destOffset = 0;
        }
        return this;
    }

    private static ByteBuffer getItemByteBuffer(ByteBuff buf, int byteBufferIndex) {
        if (buf instanceof SingleByteBuff) {
            if (byteBufferIndex != 0) {
                throw new IndexOutOfBoundsException("index:[" + byteBufferIndex + "],but only index 0 is valid.");
            }
            return buf.nioByteBuffers()[0];
        }
        MultiByteBuff multiByteBuff = (MultiByteBuff)buf;
        if (byteBufferIndex < 0 || byteBufferIndex >= multiByteBuff.items.length) {
            throw new IndexOutOfBoundsException("index:[" + byteBufferIndex + "],but only index [0-" + multiByteBuff.items.length + ") is valid.");
        }
        return multiByteBuff.items[byteBufferIndex];
    }

    private static int getItemIndexForByteBuff(ByteBuff byteBuff, int offset2, int length2) {
        if (byteBuff instanceof SingleByteBuff) {
            ByteBuffer byteBuffer = byteBuff.nioByteBuffers()[0];
            if (offset2 + length2 > byteBuffer.limit()) {
                throw new BufferUnderflowException();
            }
            return 0;
        }
        MultiByteBuff multiByteBuff = (MultiByteBuff)byteBuff;
        return multiByteBuff.getItemIndex(offset2);
    }

    private static int getRelativeOffsetForByteBuff(ByteBuff byteBuff, int globalOffset, int itemIndex) {
        if (byteBuff instanceof SingleByteBuff) {
            if (itemIndex != 0) {
                throw new IndexOutOfBoundsException("index:[" + itemIndex + "],but only index 0 is valid.");
            }
            return globalOffset;
        }
        return ((MultiByteBuff)byteBuff).getRelativeOffset(globalOffset, itemIndex);
    }

    private int getRelativeOffset(int globalOffset, int itemIndex) {
        if (itemIndex < 0 || itemIndex >= this.items.length) {
            throw new IndexOutOfBoundsException("index:[" + itemIndex + "],but only index [0-" + this.items.length + ") is valid.");
        }
        return globalOffset - this.itemBeginPos[itemIndex];
    }

    private static int getItemByteBufferCount(ByteBuff buf) {
        return buf instanceof SingleByteBuff ? 1 : ((MultiByteBuff)buf).items.length;
    }

    @Override
    public MultiByteBuff putInt(int val) {
        this.checkRefCount();
        if (this.curItem.remaining() >= 4) {
            this.curItem.putInt(val);
            return this;
        }
        if (this.curItemIndex == this.items.length - 1) {
            throw new BufferOverflowException();
        }
        this.put(MultiByteBuff.int3(val));
        this.put(MultiByteBuff.int2(val));
        this.put(MultiByteBuff.int1(val));
        this.put(MultiByteBuff.int0(val));
        return this;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    @Override
    public final MultiByteBuff put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public MultiByteBuff put(byte[] src, int offset2, int length2) {
        this.checkRefCount();
        if (this.curItem.remaining() >= length2) {
            ByteBufferUtils.copyFromArrayToBuffer(this.curItem, src, offset2, length2);
            return this;
        }
        int end2 = offset2 + length2;
        for (int i2 = offset2; i2 < end2; ++i2) {
            this.put(src[i2]);
        }
        return this;
    }

    @Override
    public MultiByteBuff putLong(long val) {
        this.checkRefCount();
        if (this.curItem.remaining() >= 8) {
            this.curItem.putLong(val);
            return this;
        }
        if (this.curItemIndex == this.items.length - 1) {
            throw new BufferOverflowException();
        }
        this.put(MultiByteBuff.long7(val));
        this.put(MultiByteBuff.long6(val));
        this.put(MultiByteBuff.long5(val));
        this.put(MultiByteBuff.long4(val));
        this.put(MultiByteBuff.long3(val));
        this.put(MultiByteBuff.long2(val));
        this.put(MultiByteBuff.long1(val));
        this.put(MultiByteBuff.long0(val));
        return this;
    }

    private static byte long7(long x) {
        return (byte)(x >> 56);
    }

    private static byte long6(long x) {
        return (byte)(x >> 48);
    }

    private static byte long5(long x) {
        return (byte)(x >> 40);
    }

    private static byte long4(long x) {
        return (byte)(x >> 32);
    }

    private static byte long3(long x) {
        return (byte)(x >> 24);
    }

    private static byte long2(long x) {
        return (byte)(x >> 16);
    }

    private static byte long1(long x) {
        return (byte)(x >> 8);
    }

    private static byte long0(long x) {
        return (byte)x;
    }

    @Override
    public MultiByteBuff skip(int length2) {
        this.checkRefCount();
        int jump = 0;
        while (true) {
            if ((jump = this.curItem.remaining()) >= length2) break;
            this.curItem.position(this.curItem.position() + jump);
            length2 -= jump;
            ++this.curItemIndex;
            this.curItem = this.items[this.curItemIndex];
        }
        this.curItem.position(this.curItem.position() + length2);
        return this;
    }

    @Override
    public MultiByteBuff moveBack(int length2) {
        this.checkRefCount();
        while (length2 != 0) {
            if (length2 > this.curItem.position()) {
                length2 -= this.curItem.position();
                this.curItem.position(0);
                --this.curItemIndex;
                this.curItem = this.items[this.curItemIndex];
                continue;
            }
            this.curItem.position(this.curItem.position() - length2);
            break;
        }
        return this;
    }

    @Override
    public ByteBuffer asSubByteBuffer(int length2) {
        this.checkRefCount();
        if (this.curItem.remaining() >= length2) {
            return this.curItem;
        }
        int offset2 = 0;
        byte[] dupB = new byte[length2];
        int locCurItemIndex = this.curItemIndex;
        ByteBuffer locCurItem = this.curItem;
        while (length2 > 0) {
            int toRead = Math.min(length2, locCurItem.remaining());
            ByteBufferUtils.copyFromBufferToArray(dupB, locCurItem, locCurItem.position(), offset2, toRead);
            if ((length2 -= toRead) == 0) break;
            locCurItem = this.items[++locCurItemIndex];
            offset2 += toRead;
        }
        return ByteBuffer.wrap(dupB);
    }

    @Override
    public void asSubByteBuffer(int offset2, int length2, ObjectIntPair<ByteBuffer> pair) {
        int itemIndex;
        ByteBuffer item;
        this.checkRefCount();
        if (this.itemBeginPos[this.curItemIndex] <= offset2) {
            int relOffsetInCurItem = offset2 - this.itemBeginPos[this.curItemIndex];
            if (this.curItem.limit() - relOffsetInCurItem >= length2) {
                pair.setFirst(this.curItem);
                pair.setSecond(relOffsetInCurItem);
                return;
            }
        }
        if ((item = this.items[itemIndex = this.getItemIndex(offset2)]).limit() - (offset2 -= this.itemBeginPos[itemIndex]) >= length2) {
            pair.setFirst(item);
            pair.setSecond(offset2);
            return;
        }
        byte[] dst = new byte[length2];
        int destOffset = 0;
        while (length2 > 0) {
            int toRead = Math.min(length2, item.limit() - offset2);
            ByteBufferUtils.copyFromBufferToArray(dst, item, offset2, destOffset, toRead);
            if ((length2 -= toRead) == 0) break;
            item = this.items[++itemIndex];
            destOffset += toRead;
            offset2 = 0;
        }
        pair.setFirst(ByteBuffer.wrap(dst));
        pair.setSecond(0);
    }

    @Override
    public void get(ByteBuffer out, int sourceOffset, int length2) {
        this.checkRefCount();
        int itemIndex = this.getItemIndex(sourceOffset);
        ByteBuffer in = this.items[itemIndex];
        sourceOffset -= this.itemBeginPos[itemIndex];
        while (length2 > 0) {
            int toRead = Math.min(in.limit() - sourceOffset, length2);
            ByteBufferUtils.copyFromBufferToBuffer(in, out, sourceOffset, toRead);
            if ((length2 -= toRead) == 0) break;
            in = this.items[++itemIndex];
            sourceOffset = 0;
        }
    }

    @Override
    public byte[] toBytes(int offset2, int length2) {
        this.checkRefCount();
        byte[] output = new byte[length2];
        this.get(offset2, output, 0, length2);
        return output;
    }

    private int internalRead(ReadableByteChannel channel, long offset2, ByteBuff.ChannelReader reader) throws IOException {
        this.checkRefCount();
        int total2 = 0;
        while (this.buffsIterator.hasNext()) {
            ByteBuffer buffer = this.buffsIterator.next();
            int len = MultiByteBuff.read(channel, buffer, offset2, reader);
            if (len > 0) {
                total2 += len;
                offset2 += (long)len;
            }
            if (!buffer.hasRemaining()) continue;
            break;
        }
        return total2;
    }

    @Override
    public int read(ReadableByteChannel channel) throws IOException {
        return this.internalRead(channel, 0L, CHANNEL_READER);
    }

    @Override
    public int read(FileChannel channel, long offset2) throws IOException {
        return this.internalRead(channel, offset2, FILE_READER);
    }

    @Override
    public int write(FileChannel channel, long offset2) throws IOException {
        this.checkRefCount();
        int total2 = 0;
        while (this.buffsIterator.hasNext()) {
            ByteBuffer buffer = this.buffsIterator.next();
            while (buffer.hasRemaining()) {
                int len = channel.write(buffer, offset2);
                total2 += len;
                offset2 += (long)len;
            }
        }
        return total2;
    }

    @Override
    public ByteBuffer[] nioByteBuffers() {
        this.checkRefCount();
        return this.items;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiByteBuff)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MultiByteBuff that = (MultiByteBuff)obj;
        if (this.capacity() != that.capacity()) {
            return false;
        }
        return ByteBuff.compareTo(this, this.position(), this.limit(), that, that.position(), that.limit()) == 0;
    }

    public int hashCode() {
        int hash2 = 0;
        for (ByteBuffer b : this.items) {
            hash2 += b.hashCode();
        }
        return hash2;
    }

    @Override
    public MultiByteBuff retain() {
        this.refCnt.retain();
        return this;
    }
}

