/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.security.AbstractHBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslOutputStream;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseSaslRpcClient
extends AbstractHBaseSaslRpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseSaslRpcClient.class);
    private boolean cryptoAesEnable;
    private CryptoAES cryptoAES;
    private InputStream saslInputStream;
    private InputStream cryptoInputStream;
    private OutputStream saslOutputStream;
    private OutputStream cryptoOutputStream;
    private boolean initStreamForCrypto;

    public HBaseSaslRpcClient(Configuration conf, SaslClientAuthenticationProvider provider, Token<? extends TokenIdentifier> token, InetAddress serverAddr, SecurityInfo securityInfo, boolean fallbackAllowed) throws IOException {
        super(conf, provider, token, serverAddr, securityInfo, fallbackAllowed);
    }

    public HBaseSaslRpcClient(Configuration conf, SaslClientAuthenticationProvider provider, Token<? extends TokenIdentifier> token, InetAddress serverAddr, SecurityInfo securityInfo, boolean fallbackAllowed, String rpcProtection, boolean initStreamForCrypto) throws IOException {
        super(conf, provider, token, serverAddr, securityInfo, fallbackAllowed, rpcProtection);
        this.initStreamForCrypto = initStreamForCrypto;
    }

    private static void readStatus(DataInputStream inStream) throws IOException {
        int status2 = inStream.readInt();
        if (status2 != SaslStatus.SUCCESS.state) {
            throw new RemoteException(WritableUtils.readString((DataInput)inStream), WritableUtils.readString((DataInput)inStream));
        }
    }

    public boolean saslConnect(InputStream inS, OutputStream outS) throws IOException {
        DataInputStream inStream = new DataInputStream(new BufferedInputStream(inS));
        DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(outS));
        try {
            block19: {
                byte[] saslToken = this.getInitialResponse();
                if (saslToken != null) {
                    outStream.writeInt(saslToken.length);
                    outStream.write(saslToken, 0, saslToken.length);
                    outStream.flush();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Have sent token of size " + saslToken.length + " from initSASLContext.");
                    }
                }
                if (!this.isComplete()) {
                    HBaseSaslRpcClient.readStatus(inStream);
                    int len = inStream.readInt();
                    if (len == -88) {
                        if (!this.fallbackAllowed) {
                            throw new IOException("Server asks us to fall back to SIMPLE auth, but this client is configured to only allow secure connections.");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Server asks us to fall back to simple auth.");
                        }
                        this.dispose();
                        return false;
                    }
                    saslToken = new byte[len];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Will read input token of size " + saslToken.length + " for processing by initSASLContext");
                    }
                    inStream.readFully(saslToken);
                }
                while (!this.isComplete()) {
                    if ((saslToken = this.evaluateChallenge(saslToken)) != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Will send token of size " + saslToken.length + " from initSASLContext.");
                        }
                        outStream.writeInt(saslToken.length);
                        outStream.write(saslToken, 0, saslToken.length);
                        outStream.flush();
                    }
                    if (this.isComplete()) continue;
                    HBaseSaslRpcClient.readStatus(inStream);
                    saslToken = new byte[inStream.readInt()];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Will read input token of size " + saslToken.length + " for processing by initSASLContext");
                    }
                    inStream.readFully(saslToken);
                }
                try {
                    HBaseSaslRpcClient.readStatus(inStream);
                }
                catch (IOException e) {
                    if (!(e instanceof RemoteException)) break block19;
                    LOG.debug("Sasl connection failed: ", e);
                    throw e;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL client context established. Negotiated QoP: " + this.saslClient.getNegotiatedProperty("javax.security.sasl.qop"));
            }
            this.saslInputStream = new SaslInputStream(inS, this.saslClient);
            this.saslOutputStream = new SaslOutputStream(outS, this.saslClient);
            if (this.initStreamForCrypto) {
                this.cryptoInputStream = new WrappedInputStream(inS);
                this.cryptoOutputStream = new WrappedOutputStream(outS);
            }
            return true;
        }
        catch (IOException e) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getSaslQOP() {
        return (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
    }

    public void initCryptoCipher(RPCProtos.CryptoCipherMeta cryptoCipherMeta, Configuration conf) throws IOException {
        this.cryptoAES = EncryptionUtil.createCryptoAES(cryptoCipherMeta, conf);
        this.cryptoAesEnable = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.saslClient.isComplete()) {
            throw new IOException("Sasl authentication exchange hasn't completed yet");
        }
        if (this.cryptoAesEnable && this.cryptoInputStream != null) {
            return this.cryptoInputStream;
        }
        return this.saslInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.saslClient.isComplete()) {
            throw new IOException("Sasl authentication exchange hasn't completed yet");
        }
        if (this.cryptoAesEnable && this.cryptoOutputStream != null) {
            return this.cryptoOutputStream;
        }
        return this.saslOutputStream;
    }

    class WrappedOutputStream
    extends FilterOutputStream {
        public WrappedOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("wrapping token of length:" + len);
            }
            byte[] wrapped = HBaseSaslRpcClient.this.cryptoAES.wrap(buf, off, len);
            DataOutputStream dob = new DataOutputStream(this.out);
            dob.writeInt(wrapped.length);
            dob.write(wrapped, 0, wrapped.length);
            dob.flush();
        }
    }

    class WrappedInputStream
    extends FilterInputStream {
        private ByteBuffer unwrappedRpcBuffer;

        public WrappedInputStream(InputStream in) throws IOException {
            super(in);
            this.unwrappedRpcBuffer = ByteBuffer.allocate(0);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            return n != -1 ? b[0] : -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            if (this.unwrappedRpcBuffer.remaining() == 0) {
                this.readNextRpcPacket();
            }
            int readLen = Math.min(len, this.unwrappedRpcBuffer.remaining());
            this.unwrappedRpcBuffer.get(buf, off, readLen);
            return readLen;
        }

        private void readNextRpcPacket() throws IOException {
            LOG.debug("reading next wrapped RPC packet");
            DataInputStream dis = new DataInputStream(this.in);
            int rpcLen = dis.readInt();
            byte[] rpcBuf = new byte[rpcLen];
            dis.readFully(rpcBuf);
            rpcBuf = HBaseSaslRpcClient.this.cryptoAES.unwrap(rpcBuf, 0, rpcBuf.length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("unwrapping token of length:" + rpcBuf.length);
            }
            this.unwrappedRpcBuffer = ByteBuffer.wrap(rpcBuf);
        }
    }
}

