/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hbase.util.MurmurHash3;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public abstract class Hash {
    public static final int INVALID_HASH = -1;
    public static final int JENKINS_HASH = 0;
    public static final int MURMUR_HASH = 1;
    public static final int MURMUR_HASH3 = 2;

    public static int parseHashType(String name2) {
        if ("jenkins".equalsIgnoreCase(name2)) {
            return 0;
        }
        if ("murmur".equalsIgnoreCase(name2)) {
            return 1;
        }
        if ("murmur3".equalsIgnoreCase(name2)) {
            return 2;
        }
        return -1;
    }

    public static int getHashType(Configuration conf) {
        String name2 = conf.get("hbase.hash.type", "murmur");
        return Hash.parseHashType(name2);
    }

    public static Hash getInstance(int type2) {
        switch (type2) {
            case 0: {
                return JenkinsHash.getInstance();
            }
            case 1: {
                return MurmurHash.getInstance();
            }
            case 2: {
                return MurmurHash3.getInstance();
            }
        }
        return null;
    }

    public static Hash getInstance(Configuration conf) {
        int type2 = Hash.getHashType(conf);
        return Hash.getInstance(type2);
    }

    public abstract <T> int hash(HashKey<T> var1, int var2);
}

