/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.util.ObjectPool;
import org.apache.hadoop.hbase.util.WeakObjectPool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class KeyLocker<K> {
    private static final int NB_CONCURRENT_LOCKS = 1000;
    private final WeakObjectPool<K, ReentrantLock> lockPool = new WeakObjectPool(new ObjectPool.ObjectFactory<K, ReentrantLock>(){

        @Override
        public ReentrantLock createObject(K key2) {
            return new ReentrantLock();
        }
    }, 1000);

    public ReentrantLock acquireLock(K key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.lockPool.purge();
        ReentrantLock lock2 = (ReentrantLock)this.lockPool.get(key2);
        lock2.lock();
        return lock2;
    }

    public Map<K, Lock> acquireLocks(Set<? extends K> keys2) {
        Object[] keyArray = keys2.toArray();
        Arrays.sort(keyArray);
        this.lockPool.purge();
        LinkedHashMap<Object, ReentrantLock> locks = new LinkedHashMap<Object, ReentrantLock>(keyArray.length);
        Object[] objectArray = keyArray;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            Object o;
            Object key2 = o = objectArray[j];
            ReentrantLock lock2 = (ReentrantLock)this.lockPool.get(key2);
            locks.put(key2, lock2);
        }
        for (Lock lock3 : locks.values()) {
            lock3.lock();
        }
        return locks;
    }
}

