/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Writables {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(Writable w) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(byteStream);){
            w.write((DataOutput)out);
            out.close();
            out = null;
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] getBytes(Writable ... ws) throws IOException {
        ArrayList<byte[]> bytes2 = new ArrayList<byte[]>(ws.length);
        int size2 = 0;
        for (Writable w : ws) {
            byte[] b = Writables.getBytes(w);
            size2 += b.length;
            bytes2.add(b);
        }
        byte[] result2 = new byte[size2];
        int offset2 = 0;
        for (byte[] b : bytes2) {
            System.arraycopy(b, 0, result2, offset2, b.length);
            offset2 += b.length;
        }
        return result2;
    }

    public static Writable getWritable(byte[] bytes2, Writable w) throws IOException {
        return Writables.getWritable(bytes2, 0, bytes2.length, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writable getWritable(byte[] bytes2, int offset2, int length2, Writable w) throws IOException {
        if (bytes2 == null || length2 <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        try (DataInputBuffer in = new DataInputBuffer();){
            in.reset(bytes2, offset2, length2);
            w.readFields((DataInput)in);
            Writable writable = w;
            return writable;
        }
    }

    public static Writable copyWritable(Writable src, Writable tgt) throws IOException {
        return Writables.copyWritable(Writables.getBytes(src), tgt);
    }

    public static Writable copyWritable(byte[] bytes2, Writable tgt) throws IOException {
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes2));){
            tgt.readFields((DataInput)dis);
        }
        return tgt;
    }
}

