/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.common.util.concurrent;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.hbase.thirdparty.com.google.common.annotations.GwtIncompatible;
import org.apache.hbase.thirdparty.com.google.common.primitives.ImmutableLongArray;

@GwtIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length2) {
        this.longs = new AtomicLongArray(length2);
    }

    public AtomicDoubleArray(double[] array) {
        int len = array.length;
        long[] longArray = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            longArray[i2] = Double.doubleToRawLongBits(array[i2]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i2) {
        return Double.longBitsToDouble(this.longs.get(i2));
    }

    public final void set(int i2, double newValue) {
        long next2 = Double.doubleToRawLongBits(newValue);
        this.longs.set(i2, next2);
    }

    public final void lazySet(int i2, double newValue) {
        long next2 = Double.doubleToRawLongBits(newValue);
        this.longs.lazySet(i2, next2);
    }

    public final double getAndSet(int i2, double newValue) {
        long next2 = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i2, next2));
    }

    public final boolean compareAndSet(int i2, double expect, double update2) {
        return this.longs.compareAndSet(i2, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update2));
    }

    public final boolean weakCompareAndSet(int i2, double expect, double update2) {
        return this.longs.weakCompareAndSet(i2, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update2));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int i2, double delta) {
        double currentVal;
        double nextVal;
        long next2;
        long current2;
        while (!this.longs.compareAndSet(i2, current2 = this.longs.get(i2), next2 = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current2)) + delta))) {
        }
        return currentVal;
    }

    @CanIgnoreReturnValue
    public double addAndGet(int i2, double delta) {
        double currentVal;
        double nextVal;
        long next2;
        long current2;
        while (!this.longs.compareAndSet(i2, current2 = this.longs.get(i2), next2 = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current2)) + delta))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(19 * (iMax + 1));
        b.append('[');
        int i2 = 0;
        while (true) {
            b.append(Double.longBitsToDouble(this.longs.get(i2)));
            if (i2 == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i2;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int length2 = this.length();
        s2.writeInt(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            s2.writeDouble(this.get(i2));
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int length2 = s2.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i2 = 0; i2 < length2; ++i2) {
            builder.add(Double.doubleToRawLongBits(s2.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

