/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.gson.internal.bind.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final String UTC_ID = "UTC";
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean millis) {
        return ISO8601Utils.format(date, millis, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean millis, TimeZone tz) {
        int offset2;
        GregorianCalendar calendar = new GregorianCalendar(tz, Locale.US);
        calendar.setTime(date);
        int capacity = "yyyy-MM-ddThh:mm:ss".length();
        capacity += millis ? ".sss".length() : 0;
        StringBuilder formatted = new StringBuilder(capacity += tz.getRawOffset() == 0 ? "Z".length() : "+hh:mm".length());
        ISO8601Utils.padInt(formatted, calendar.get(1), "yyyy".length());
        formatted.append('-');
        ISO8601Utils.padInt(formatted, calendar.get(2) + 1, "MM".length());
        formatted.append('-');
        ISO8601Utils.padInt(formatted, calendar.get(5), "dd".length());
        formatted.append('T');
        ISO8601Utils.padInt(formatted, calendar.get(11), "hh".length());
        formatted.append(':');
        ISO8601Utils.padInt(formatted, calendar.get(12), "mm".length());
        formatted.append(':');
        ISO8601Utils.padInt(formatted, calendar.get(13), "ss".length());
        if (millis) {
            formatted.append('.');
            ISO8601Utils.padInt(formatted, calendar.get(14), "sss".length());
        }
        if ((offset2 = tz.getOffset(calendar.getTimeInMillis())) != 0) {
            int hours = Math.abs(offset2 / 60000 / 60);
            int minutes = Math.abs(offset2 / 60000 % 60);
            formatted.append(offset2 < 0 ? (char)'-' : '+');
            ISO8601Utils.padInt(formatted, hours, "hh".length());
            formatted.append(':');
            ISO8601Utils.padInt(formatted, minutes, "mm".length());
        } else {
            formatted.append('Z');
        }
        return formatted.toString();
    }

    public static Date parse(String date, ParsePosition pos2) throws ParseException {
        RuntimeException fail = null;
        try {
            int offset2 = pos2.getIndex();
            int year2 = ISO8601Utils.parseInt(date, offset2, offset2 += 4);
            if (ISO8601Utils.checkOffset(date, offset2, '-')) {
                // empty if block
            }
            int month2 = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            if (ISO8601Utils.checkOffset(date, offset2, '-')) {
                // empty if block
            }
            int day = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            int hour2 = 0;
            int minutes = 0;
            int seconds = 0;
            int milliseconds = 0;
            boolean hasT = ISO8601Utils.checkOffset(date, offset2, 'T');
            if (!hasT && date.length() <= offset2) {
                GregorianCalendar calendar = new GregorianCalendar(year2, month2 - 1, day);
                pos2.setIndex(offset2);
                return calendar.getTime();
            }
            if (hasT) {
                char c;
                hour2 = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
                if (ISO8601Utils.checkOffset(date, offset2, ':')) {
                    // empty if block
                }
                minutes = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
                if (ISO8601Utils.checkOffset(date, offset2, ':')) {
                    ++offset2;
                }
                if (date.length() > offset2 && (c = date.charAt(offset2)) != 'Z' && c != '+' && c != '-') {
                    if ((seconds = ISO8601Utils.parseInt(date, offset2, offset2 += 2)) > 59 && seconds < 63) {
                        seconds = 59;
                    }
                    if (ISO8601Utils.checkOffset(date, offset2, '.')) {
                        int endOffset = ISO8601Utils.indexOfNonDigit(date, ++offset2 + 1);
                        int parseEndOffset = Math.min(endOffset, offset2 + 3);
                        int fraction = ISO8601Utils.parseInt(date, offset2, parseEndOffset);
                        switch (parseEndOffset - offset2) {
                            case 2: {
                                milliseconds = fraction * 10;
                                break;
                            }
                            case 1: {
                                milliseconds = fraction * 100;
                                break;
                            }
                            default: {
                                milliseconds = fraction;
                            }
                        }
                        offset2 = endOffset;
                    }
                }
            }
            if (date.length() <= offset2) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            TimeZone timezone = null;
            char timezoneIndicator = date.charAt(offset2);
            if (timezoneIndicator == 'Z') {
                timezone = TIMEZONE_UTC;
                ++offset2;
            } else if (timezoneIndicator == '+' || timezoneIndicator == '-') {
                String timezoneOffset = date.substring(offset2);
                timezoneOffset = timezoneOffset.length() >= 5 ? timezoneOffset : timezoneOffset + "00";
                offset2 += timezoneOffset.length();
                if ("+0000".equals(timezoneOffset) || "+00:00".equals(timezoneOffset)) {
                    timezone = TIMEZONE_UTC;
                } else {
                    String cleaned;
                    String timezoneId = "GMT" + timezoneOffset;
                    timezone = TimeZone.getTimeZone(timezoneId);
                    String act = timezone.getID();
                    if (!act.equals(timezoneId) && !(cleaned = act.replace(":", "")).equals(timezoneId)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + timezoneId + " given, resolves to " + timezone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + timezoneIndicator + "'");
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year2);
            calendar.set(2, month2 - 1);
            calendar.set(5, day);
            calendar.set(11, hour2);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            pos2.setIndex(offset2);
            return calendar.getTime();
        }
        catch (IndexOutOfBoundsException e) {
            fail = e;
        }
        catch (NumberFormatException e) {
            fail = e;
        }
        catch (IllegalArgumentException e) {
            fail = e;
        }
        String input = date == null ? null : '\"' + date + '\"';
        String msg = fail.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = "(" + fail.getClass().getName() + ")";
        }
        ParseException ex = new ParseException("Failed to parse date [" + input + "]: " + msg, pos2.getIndex());
        ex.initCause(fail);
        throw ex;
    }

    private static boolean checkOffset(String value2, int offset2, char expected) {
        return offset2 < value2.length() && value2.charAt(offset2) == expected;
    }

    private static int parseInt(String value2, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value2.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value2);
        }
        int i2 = beginIndex;
        int result2 = 0;
        if (i2 < endIndex) {
            if ((digit = Character.digit(value2.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value2.substring(beginIndex, endIndex));
            }
            result2 = -digit;
        }
        while (i2 < endIndex) {
            if ((digit = Character.digit(value2.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value2.substring(beginIndex, endIndex));
            }
            result2 *= 10;
            result2 -= digit;
        }
        return -result2;
    }

    private static void padInt(StringBuilder buffer, int value2, int length2) {
        String strValue = Integer.toString(value2);
        for (int i2 = length2 - strValue.length(); i2 > 0; --i2) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }

    private static int indexOfNonDigit(String string2, int offset2) {
        for (int i2 = offset2; i2 < string2.length(); ++i2) {
            char c = string2.charAt(i2);
            if (c >= '0' && c <= '9') continue;
            return i2;
        }
        return string2.length();
    }
}

