/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hbase.thirdparty.com.google.protobuf.ArrayDecoders;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite;
import org.apache.hbase.thirdparty.com.google.protobuf.ExtensionSchema;
import org.apache.hbase.thirdparty.com.google.protobuf.FieldSet;
import org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageLite;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.LazyField;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageLite;
import org.apache.hbase.thirdparty.com.google.protobuf.Protobuf;
import org.apache.hbase.thirdparty.com.google.protobuf.Reader;
import org.apache.hbase.thirdparty.com.google.protobuf.Schema;
import org.apache.hbase.thirdparty.com.google.protobuf.SchemaUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSchema;
import org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSetLite;
import org.apache.hbase.thirdparty.com.google.protobuf.WireFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.Writer;

final class MessageSetSchema<T>
implements Schema<T> {
    private final MessageLite defaultInstance;
    private final UnknownFieldSchema<?, ?> unknownFieldSchema;
    private final boolean hasExtensions;
    private final ExtensionSchema<?> extensionSchema;

    private MessageSetSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        this.unknownFieldSchema = unknownFieldSchema;
        this.hasExtensions = extensionSchema.hasExtensions(defaultInstance);
        this.extensionSchema = extensionSchema;
        this.defaultInstance = defaultInstance;
    }

    static <T> MessageSetSchema<T> newSchema(UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MessageLite defaultInstance) {
        return new MessageSetSchema<T>(unknownFieldSchema, extensionSchema, defaultInstance);
    }

    @Override
    public T newInstance() {
        return (T)this.defaultInstance.newBuilderForType().buildPartial();
    }

    @Override
    public boolean equals(T message2, T other) {
        Object otherUnknown;
        Object messageUnknown = this.unknownFieldSchema.getFromMessage(message2);
        if (!messageUnknown.equals(otherUnknown = this.unknownFieldSchema.getFromMessage(other))) {
            return false;
        }
        if (this.hasExtensions) {
            FieldSet<?> messageExtensions = this.extensionSchema.getExtensions(message2);
            FieldSet<?> otherExtensions = this.extensionSchema.getExtensions(other);
            return messageExtensions.equals(otherExtensions);
        }
        return true;
    }

    @Override
    public int hashCode(T message2) {
        int hashCode = this.unknownFieldSchema.getFromMessage(message2).hashCode();
        if (this.hasExtensions) {
            FieldSet<?> extensions = this.extensionSchema.getExtensions(message2);
            hashCode = hashCode * 53 + extensions.hashCode();
        }
        return hashCode;
    }

    @Override
    public void mergeFrom(T message2, T other) {
        SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, message2, other);
        if (this.hasExtensions) {
            SchemaUtil.mergeExtensions(this.extensionSchema, message2, other);
        }
    }

    @Override
    public void writeTo(T message2, Writer writer) throws IOException {
        FieldSet<?> extensions = this.extensionSchema.getExtensions(message2);
        Iterator<Map.Entry<?, Object>> iterator = extensions.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, Object> extension = iterator.next();
            FieldSet.FieldDescriptorLite fd = (FieldSet.FieldDescriptorLite)extension.getKey();
            if (fd.getLiteJavaType() != WireFormat.JavaType.MESSAGE || fd.isRepeated() || fd.isPacked()) {
                throw new IllegalStateException("Found invalid MessageSet item.");
            }
            if (extension instanceof LazyField.LazyEntry) {
                writer.writeMessageSetItem(fd.getNumber(), ((LazyField.LazyEntry)extension).getField().toByteString());
                continue;
            }
            writer.writeMessageSetItem(fd.getNumber(), extension.getValue());
        }
        this.writeUnknownFieldsHelper(this.unknownFieldSchema, message2, writer);
    }

    private <UT, UB> void writeUnknownFieldsHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, T message2, Writer writer) throws IOException {
        unknownFieldSchema.writeAsMessageSetTo(unknownFieldSchema.getFromMessage(message2), writer);
    }

    @Override
    public void mergeFrom(T message2, byte[] data, int position, int limit2, ArrayDecoders.Registers registers) throws IOException {
        UnknownFieldSetLite unknownFields = ((GeneratedMessageLite)message2).unknownFields;
        if (unknownFields == UnknownFieldSetLite.getDefaultInstance()) {
            ((GeneratedMessageLite)message2).unknownFields = unknownFields = UnknownFieldSetLite.newInstance();
        }
        FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions = ((GeneratedMessageLite.ExtendableMessage)message2).ensureExtensionsAreMutable();
        GeneratedMessageLite.GeneratedExtension extension = null;
        while (position < limit2) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            int startTag = registers.int1;
            if (startTag != WireFormat.MESSAGE_SET_ITEM_TAG) {
                if (WireFormat.getTagWireType(startTag) == 2) {
                    extension = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, WireFormat.getTagFieldNumber(startTag));
                    if (extension != null) {
                        position = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(extension.getMessageDefaultInstance().getClass()), data, position, limit2, registers);
                        extensions.setField(extension.descriptor, registers.object1);
                        continue;
                    }
                    position = ArrayDecoders.decodeUnknownField(startTag, data, position, limit2, unknownFields, registers);
                    continue;
                }
                position = ArrayDecoders.skipField(startTag, data, position, limit2, registers);
                continue;
            }
            int typeId = 0;
            ByteString rawBytes = null;
            block5: while (position < limit2) {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                int tag2 = registers.int1;
                int number = WireFormat.getTagFieldNumber(tag2);
                int wireType = WireFormat.getTagWireType(tag2);
                switch (number) {
                    case 2: {
                        if (wireType != 0) break;
                        position = ArrayDecoders.decodeVarint32(data, position, registers);
                        typeId = registers.int1;
                        extension = (GeneratedMessageLite.GeneratedExtension)this.extensionSchema.findExtensionByNumber(registers.extensionRegistry, this.defaultInstance, typeId);
                        continue block5;
                    }
                    case 3: {
                        if (extension != null) {
                            position = ArrayDecoders.decodeMessageField(Protobuf.getInstance().schemaFor(extension.getMessageDefaultInstance().getClass()), data, position, limit2, registers);
                            extensions.setField(extension.descriptor, registers.object1);
                            continue block5;
                        }
                        if (wireType != 2) break;
                        position = ArrayDecoders.decodeBytes(data, position, registers);
                        rawBytes = (ByteString)registers.object1;
                        continue block5;
                    }
                }
                if (tag2 == WireFormat.MESSAGE_SET_ITEM_END_TAG) break;
                position = ArrayDecoders.skipField(tag2, data, position, limit2, registers);
            }
            if (rawBytes == null) continue;
            unknownFields.storeField(WireFormat.makeTag(typeId, 2), rawBytes);
        }
        if (position != limit2) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    @Override
    public void mergeFrom(T message2, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.mergeFromHelper(this.unknownFieldSchema, this.extensionSchema, message2, reader, extensionRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> void mergeFromHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, ExtensionSchema<ET> extensionSchema, T message2, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        UB unknownFields = unknownFieldSchema.getBuilderFromMessage(message2);
        FieldSet<ET> extensions = extensionSchema.getMutableExtensions(message2);
        try {
            do {
                int number;
                if ((number = reader.getFieldNumber()) != Integer.MAX_VALUE) continue;
                return;
            } while (this.parseMessageSetItemOrUnknownField(reader, extensionRegistry, extensionSchema, extensions, unknownFieldSchema, unknownFields));
            return;
        }
        finally {
            unknownFieldSchema.setBuilderToMessage(message2, unknownFields);
        }
    }

    @Override
    public void makeImmutable(T message2) {
        this.unknownFieldSchema.makeImmutable(message2);
        this.extensionSchema.makeImmutable(message2);
    }

    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> boolean parseMessageSetItemOrUnknownField(Reader reader, ExtensionRegistryLite extensionRegistry, ExtensionSchema<ET> extensionSchema, FieldSet<ET> extensions, UnknownFieldSchema<UT, UB> unknownFieldSchema, UB unknownFields) throws IOException {
        int number;
        int startTag = reader.getTag();
        if (startTag != WireFormat.MESSAGE_SET_ITEM_TAG) {
            if (WireFormat.getTagWireType(startTag) == 2) {
                Object extension = extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, WireFormat.getTagFieldNumber(startTag));
                if (extension != null) {
                    extensionSchema.parseLengthPrefixedMessageSetItem(reader, extension, extensionRegistry, extensions);
                    return true;
                }
                return unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader);
            }
            return reader.skipField();
        }
        int typeId = 0;
        ByteString rawBytes = null;
        Object extension = null;
        while ((number = reader.getFieldNumber()) != Integer.MAX_VALUE) {
            int tag2 = reader.getTag();
            if (tag2 == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                typeId = reader.readUInt32();
                extension = extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, typeId);
                continue;
            }
            if (tag2 == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                if (extension != null) {
                    extensionSchema.parseLengthPrefixedMessageSetItem(reader, extension, extensionRegistry, extensions);
                    continue;
                }
                rawBytes = reader.readBytes();
                continue;
            }
            if (reader.skipField()) continue;
            break;
        }
        if (reader.getTag() != WireFormat.MESSAGE_SET_ITEM_END_TAG) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
        if (rawBytes != null) {
            if (extension != null) {
                extensionSchema.parseMessageSetItem(rawBytes, extension, extensionRegistry, extensions);
            } else {
                unknownFieldSchema.addLengthDelimited(unknownFields, typeId, rawBytes);
            }
        }
        return true;
    }

    @Override
    public final boolean isInitialized(T message2) {
        FieldSet<?> extensions = this.extensionSchema.getExtensions(message2);
        return extensions.isInitialized();
    }

    @Override
    public int getSerializedSize(T message2) {
        int size2 = 0;
        size2 += this.getUnknownFieldsSerializedSize(this.unknownFieldSchema, message2);
        if (this.hasExtensions) {
            size2 += this.extensionSchema.getExtensions(message2).getMessageSetSerializedSize();
        }
        return size2;
    }

    private <UT, UB> int getUnknownFieldsSerializedSize(UnknownFieldSchema<UT, UB> schema, T message2) {
        UT unknowns = schema.getFromMessage(message2);
        return schema.getSerializedSizeAsMessageSet(unknowns);
    }
}

